/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.transport;

import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSLogManager;
import com.dls.jpos.transport.DataReceivedListener;
import com.dls.jpos.transport.DeviceAddedListener;
import com.dls.jpos.transport.DeviceReattachedListener;
import com.dls.jpos.transport.DeviceRemovedListener;
import java.util.Enumeration;
import java.util.Vector;

public abstract class DLSPort {
    protected DLSLogManager log = DLSLogManager.getInstance();
    protected Vector dataReceivedListeners = new Vector();
    protected Vector deviceReattachedListeners = new Vector();
    protected Vector deviceRemovedListeners = new Vector();
    protected Vector deviceAddedListeners = new Vector();
    protected DLSDeviceInfo info;
    protected boolean bOpen = false;

    public DLSPort(DLSDeviceInfo info) {
        this.info = info;
    }

    protected void finalize() {
        this.closePort();
    }

    public abstract boolean openPort();

    public abstract boolean closePort();

    public abstract void changeBaudRate(int var1);

    public abstract boolean startLiveWeight(byte[] var1, int var2, int var3);

    public abstract void stopLiveWeight();

    public boolean isOpen() {
        this.log.trace(this, "isOpen: " + this.bOpen);
        return this.bOpen;
    }

    public int sendData(String strBuf) {
        return this.sendData(strBuf.getBytes(), strBuf.length());
    }

    public int sendData(byte[] buf) {
        return this.sendData(buf, buf.length);
    }

    public abstract int sendData(byte[] var1, int var2);

    public void setRTS(boolean bValue) {
        this.log.in(this, "setRTS");
        this.log.out(this, "setRTS");
    }

    public boolean isDSR() {
        this.log.in(this, "isDSR");
        this.log.out(this, "isDSR");
        return false;
    }

    public void addDataReceivedListener(DataReceivedListener drl) {
        this.log.in(this, "addDataReceivedListener");
        this.dataReceivedListeners.addElement(drl);
        this.log.out(this, "addDataReceivedListener");
    }

    public void removeDataReceivedListener(DataReceivedListener drl) {
        this.log.in(this, "removeDataReceivedListener");
        this.dataReceivedListeners.removeElement(drl);
        this.log.out(this, "removeDataReceivedListener");
    }

    protected void fireDataReceivedEvent(byte[] buf, int len) {
        Enumeration e = this.dataReceivedListeners.elements();
        while (e.hasMoreElements()) {
            DataReceivedListener listener = (DataReceivedListener)e.nextElement();
            listener.onDataReceived(buf, len);
        }
    }

    public void addDeviceRemovedListener(DeviceRemovedListener drl) {
        this.log.in(this, "addDeviceRemovedListener");
        this.deviceRemovedListeners.addElement(drl);
        this.log.out(this, "addDeviceRemovedListener");
    }

    public void removeDeviceRemovedListener(DeviceRemovedListener drl) {
        this.log.in(this, "removeDeviceRemovedListener");
        this.deviceRemovedListeners.removeElement(drl);
        this.log.out(this, "removeDeviceRemovedListener");
    }

    protected void fireDeviceRemovedEvent() {
        this.log.in(this, "fireDeviceRemovedEvent");
        Enumeration e = this.deviceRemovedListeners.elements();
        while (e.hasMoreElements()) {
            DeviceRemovedListener listener = (DeviceRemovedListener)e.nextElement();
            listener.onDeviceRemoved();
        }
        this.log.out(this, "fireDeviceRemovedEvent");
    }

    public void addDeviceReattachedListener(DeviceReattachedListener drl) {
        this.log.in(this, "addDeviceReattachedListener");
        this.deviceReattachedListeners.addElement(drl);
        this.log.out(this, "addDeviceReattachedListener");
    }

    public void removeDeviceReattachedListener(DeviceReattachedListener drl) {
        this.log.in(this, "removeDeviceReattachedListener");
        this.deviceReattachedListeners.removeElement(drl);
        this.log.out(this, "removeDeviceReattachedListener");
    }

    protected void fireDeviceReattachedEvent() {
        this.log.in(this, "fireDeviceReattachedEvent");
        Enumeration e = this.deviceReattachedListeners.elements();
        while (e.hasMoreElements()) {
            DeviceReattachedListener listener = (DeviceReattachedListener)e.nextElement();
            listener.onDeviceReattached();
        }
        this.log.out(this, "fireDeviceReattachedEvent");
    }

    public void addDeviceAddedListener(DeviceReattachedListener drl) {
        this.log.in(this, "addDeviceAddedListener");
        this.deviceAddedListeners.addElement(drl);
        this.log.out(this, "addDeviceAddedListener");
    }

    public void removeDeviceAddedListener(DeviceReattachedListener drl) {
        this.log.in(this, "removeDeviceAddedListener");
        this.deviceAddedListeners.removeElement(drl);
        this.log.out(this, "removeDeviceAddedListener");
    }

    protected void fireDeviceAddedEvent() {
        this.log.in(this, "fireDeviceAddedEvent");
        Enumeration e = this.deviceAddedListeners.elements();
        while (e.hasMoreElements()) {
            DeviceAddedListener listener = (DeviceAddedListener)e.nextElement();
            listener.onDeviceAdded();
        }
        this.log.out(this, "fireDeviceAddedEvent");
    }
}

