/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.DLSCConfig;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSScaleConfig;
import com.dls.jpos.interpretation.DLSDevice;
import com.dls.jpos.interpretation.WeightReceivedListener;
import java.util.Enumeration;
import java.util.Vector;

public abstract class DLSScale
extends DLSDevice {
    protected DLSScaleConfig scaleConfig = null;
    protected Vector weightReceivedListeners = new Vector();
    protected boolean bMetricMode = false;
    private boolean bZeroValid = false;
    protected int nStatusNotify = 1;
    private int nLiveWeight = 0;
    private int nStatusValue = 0;
    private int nPollRate = 500;
    private LiveWeightThread thrLiveWeight = new LiveWeightThread();

    public abstract void clearDisplay() throws DLSException;

    public abstract void zeroScale() throws DLSException;

    public abstract boolean canZeroScale();

    public abstract void updateConfiguration() throws DLSException;

    public abstract void reportConfiguration() throws DLSException;

    public abstract void readMetricWeight() throws DLSException;

    public abstract void readEnglishWeight() throws DLSException;

    public abstract void readStatusWeight() throws DLSException;

    public abstract void onStatusUpdate(int var1);

    public void open(String strLogicalName) throws DLSException {
        this.log.in(this, "open");
        super.open(strLogicalName);
        this.scaleConfig = new DLSScaleConfig();
        this.scaleConfig.loadConfiguration(strLogicalName);
        this.nPollRate = this.scaleConfig.getLiveWeightPoll();
        this.bMetricMode = this.scaleConfig.getMetricWeightMode();
        this.bZeroValid = this.scaleConfig.getZeroValid();
        this.log.out(this, "open");
    }

    public void claim(long lTimeout) throws DLSException {
        this.log.in(this, "Scale claim");
        super.claim(lTimeout);
        this.enable3ByteStatus();
        DLSProperties options = DLSProperties.getInstance();
        if (options.get("com.dls.jpos.interpretation.autoLoadConfig", false)) {
            this.updateConfiguration();
        }
        this.reportConfiguration();
        this.log.out(this, "Scale claim");
    }

    protected void enable3ByteStatus() {
        this.log.in(this, "enable3ByteStatus");
    }

    public DLSCConfig getConfiguration() {
        return this.scaleConfig;
    }

    public boolean getMetricMode() {
        return this.bMetricMode;
    }

    public boolean getZeroValid() {
        return this.scaleConfig.getZeroValid();
    }

    public void setZeroValid(boolean zeroValid) {
        this.scaleConfig.setZeroValid(zeroValid);
    }

    public void setMetricMode(boolean bValue) {
        this.bMetricMode = bValue;
    }

    public boolean canStatusUpdate() {
        return this.scaleConfig.getCanStatusUpdate();
    }

    public int getStatusNotify() {
        return this.nStatusNotify;
    }

    public void setStatusNotify(int nValue) {
        if (this.nStatusNotify != nValue) {
            this.thrLiveWeight.bLiveWeight = false;
        }
        this.nStatusNotify = nValue;
    }

    public int getPollRate() {
        return this.nPollRate;
    }

    public synchronized int getLiveWeight() {
        return this.nLiveWeight;
    }

    protected synchronized void setLiveWeight(int nWeight) {
        this.nLiveWeight = nWeight;
    }

    public boolean isLiveWeight() {
        return this.thrLiveWeight.bLiveWeight;
    }

    protected synchronized int getStatusValue() {
        return this.nStatusValue;
    }

    protected synchronized void setStatusValue(int nStatus) {
        this.nStatusValue = nStatus;
    }

    protected void startLiveWeight() {
        if (this.thrLiveWeight.bLiveWeight) {
            return;
        }
        this.thrLiveWeight.bLiveWeight = true;
        this.thrLiveWeight.start();
    }

    protected void stopLiveWeight() {
        if (this.thrLiveWeight.bLiveWeight) {
            this.log.log(this, "Stopping live weight.");
        }
        this.thrLiveWeight.bLiveWeight = false;
    }

    public void addWeightReceivedListener(WeightReceivedListener wrl) {
        this.log.in(this, "addWeightReceivedListener");
        this.weightReceivedListeners.addElement(wrl);
        this.log.out(this, "addWeightReceivedListener");
    }

    public void removeWeightReceivedListener(WeightReceivedListener wrl) {
        this.log.in(this, "removeWeightReceivedListener");
        this.weightReceivedListeners.removeElement(wrl);
        this.log.out(this, "removeWeightReceivedListener");
    }

    protected void fireWeightReceivedEvent(int weight) {
        this.log.in(this, "fireWeightReceivedEvent");
        Enumeration e = this.weightReceivedListeners.elements();
        while (e.hasMoreElements()) {
            WeightReceivedListener listener = (WeightReceivedListener)e.nextElement();
            listener.onWeightReceived(weight);
        }
        this.log.out(this, "fireWeightReceivedEvent");
    }

    private class LiveWeightThread
    extends Thread {
        public boolean bLiveWeight = false;

        private LiveWeightThread() {
        }

        public void run() {
            DLSScale.this.log.log(this, "Starting live weight.");
            while (this.bLiveWeight) {
                try {
                    if (DLSScale.this.log.getFWBusy()) {
                        LiveWeightThread.sleep(15000L);
                    } else {
                        LiveWeightThread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    DLSScale.this.log.error(this, "liveweight sleep interrupted");
                }
                try {
                    DLSScale.this.readStatusWeight();
                }
                catch (DLSException e) {
                    DLSScale.this.log.error(this, e.getMessage());
                }
            }
            DLSScale.this.log.log(this, "End live weight.");
        }
    }
}

