/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.GUIPrefs;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IzPackMetalTheme;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.OsVersion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class GUIInstaller
extends InstallerBase {
    private InstallData installdata = new InstallData();
    protected String lnf;
    static /* synthetic */ Class class$com$izforge$izpack$installer$GUIInstaller$LanguageDialog;

    public GUIInstaller() throws Exception {
        this.loadInstallData(this.installdata);
        this.loadGUIInstallData();
        this.loadLookAndFeel();
        this.checkJavaVersion();
        this.loadLangPack();
        ResourceManager.create(this.installdata);
        this.loadGUI();
    }

    public void loadGUIInstallData() throws Exception {
        InputStream in = GUIInstaller.class.getResourceAsStream("/GUIPrefs");
        ObjectInputStream objIn = new ObjectInputStream(in);
        this.installdata.guiPrefs = (GUIPrefs)objIn.readObject();
        objIn.close();
    }

    private void checkJavaVersion() throws Exception {
        String required;
        String version = System.getProperty("java.version");
        if (version.compareTo(required = this.installdata.info.getJavaVersion()) < 0) {
            StringBuffer msg = new StringBuffer();
            msg.append("The application that you are trying to install requires a ");
            msg.append(required);
            msg.append(" version or later of the Java platform.\n");
            msg.append("You are running a ");
            msg.append(version);
            msg.append(" version of the Java platform.\n");
            msg.append("Please upgrade to a newer version.");
            System.out.println(msg.toString());
            JOptionPane.showMessageDialog(null, msg.toString(), "Error", 0);
            System.exit(1);
        }
    }

    private void loadLangPack() throws Exception {
        String selectedPack;
        List availableLangPacks = this.getAvailableLangPacks();
        int npacks = availableLangPacks.size();
        if (npacks == 0) {
            throw new Exception("no language pack available");
        }
        JFrame frame = new JFrame();
        frame.setIconImage(new ImageIcon(this.getClass().getResource("/img/JFrameIcon.png")).getImage());
        Dimension frameSize = frame.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2 - 10);
        if (npacks != 1) {
            LanguageDialog picker = new LanguageDialog(frame, availableLangPacks.toArray());
            picker.setSelection(Locale.getDefault().getISO3Country().toLowerCase());
            picker.setModal(true);
            picker.toFront();
            frame.show();
            frame.hide();
            picker.show();
            selectedPack = (String)picker.getSelection();
            if (selectedPack == null) {
                throw new Exception("installation canceled");
            }
        } else {
            selectedPack = (String)availableLangPacks.get(0);
        }
        this.installdata.xmlData.setAttribute("langpack", selectedPack);
        this.installdata.localeISO3 = selectedPack;
        this.installdata.setVariable("ISO3_LANG", this.installdata.localeISO3);
        InputStream in = this.getClass().getResourceAsStream("/langpacks/" + selectedPack + ".xml");
        this.installdata.langpack = new LocaleDatabase(in);
    }

    private List getAvailableLangPacks() throws Exception {
        InputStream in = this.getClass().getResourceAsStream("/langpacks.info");
        ObjectInputStream objIn = new ObjectInputStream(in);
        List available = (List)objIn.readObject();
        objIn.close();
        return available;
    }

    protected void loadLookAndFeel() throws Exception {
        String syskey = "unix";
        if (OsVersion.IS_WINDOWS) {
            syskey = "windows";
        } else if (OsVersion.IS_OSX) {
            syskey = "mac";
        }
        String laf = null;
        if (this.installdata.guiPrefs.lookAndFeelMapping.containsKey(syskey)) {
            laf = (String)this.installdata.guiPrefs.lookAndFeelMapping.get(syskey);
        }
        boolean useButtonIcons = true;
        if (this.installdata.guiPrefs.modifier.containsKey("useButtonIcons") && ((String)this.installdata.guiPrefs.modifier.get("useButtonIcons")).equalsIgnoreCase("no")) {
            useButtonIcons = false;
        }
        ButtonFactory.useButtonIcons(useButtonIcons);
        boolean useLabelIcons = true;
        if (this.installdata.guiPrefs.modifier.containsKey("useLabelIcons") && ((String)this.installdata.guiPrefs.modifier.get("useLabelIcons")).equalsIgnoreCase("no")) {
            useLabelIcons = false;
        }
        LabelFactory.setUseLabelIcons(useLabelIcons);
        if (laf == null) {
            if (!syskey.equals("mac")) {
                String syslaf = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(syslaf);
                if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                    MetalLookAndFeel.setCurrentTheme(new IzPackMetalTheme());
                    ButtonFactory.useHighlightButtons();
                    ButtonFactory.useButtonIcons(useButtonIcons);
                    this.installdata.buttonsHColor = new Color(182, 182, 204);
                }
            }
            this.lnf = "swing";
            return;
        }
        if (laf.equals("kunststoff")) {
            ButtonFactory.useHighlightButtons();
            ButtonFactory.useButtonIcons(useButtonIcons);
            this.installdata.buttonsHColor = new Color(255, 255, 255);
            Class<?> lafClass = Class.forName("com.incors.plaf.kunststoff.KunststoffLookAndFeel");
            Class<?> mtheme = Class.forName("javax.swing.plaf.metal.MetalTheme");
            Class[] params = new Class[]{mtheme};
            Class<?> theme = Class.forName("com.izforge.izpack.gui.IzPackKMetalTheme");
            Method setCurrentThemeMethod = lafClass.getMethod("setCurrentTheme", params);
            LookAndFeel kunststoff = (LookAndFeel)lafClass.newInstance();
            MetalTheme ktheme = (MetalTheme)theme.newInstance();
            Object[] kparams = new Object[]{ktheme};
            UIManager.setLookAndFeel(kunststoff);
            setCurrentThemeMethod.invoke((Object)kunststoff, kparams);
            this.lnf = "kunststoff";
            return;
        }
        if (laf.equals("liquid")) {
            String value;
            UIManager.setLookAndFeel("com.birosoft.liquid.LiquidLookAndFeel");
            this.lnf = "liquid";
            Map params = (Map)this.installdata.guiPrefs.lookAndFeelParams.get(laf);
            if (params.containsKey("decorate.frames") && (value = (String)params.get("decorate.frames")).equals("yes")) {
                JFrame.setDefaultLookAndFeelDecorated(true);
            }
            if (params.containsKey("decorate.dialogs") && (value = (String)params.get("decorate.dialogs")).equals("yes")) {
                JDialog.setDefaultLookAndFeelDecorated(true);
            }
            return;
        }
        if (laf.equals("metouia")) {
            UIManager.setLookAndFeel("net.sourceforge.mlf.metouia.MetouiaLookAndFeel");
            this.lnf = "metouia";
            return;
        }
        if (laf.equals("looks")) {
            String param;
            TreeMap<String, String> variants = new TreeMap<String, String>();
            variants.put("extwin", "com.jgoodies.plaf.windows.ExtWindowsLookAndFeel");
            variants.put("plastic", "com.jgoodies.plaf.plastic.PlasticLookAndFeel");
            variants.put("plastic3D", "com.jgoodies.plaf.plastic.Plastic3DLookAndFeel");
            variants.put("plasticXP", "com.jgoodies.plaf.plastic.PlasticXPLookAndFeel");
            String variant = (String)variants.get("plasticXP");
            Map params = (Map)this.installdata.guiPrefs.lookAndFeelParams.get(laf);
            if (params.containsKey("variant") && variants.containsKey(param = (String)params.get("variant"))) {
                variant = (String)variants.get(param);
            }
            UIManager.setLookAndFeel(variant);
        }
    }

    private void loadGUI() throws Exception {
        UIManager.put("OptionPane.yesButtonText", this.installdata.langpack.getString("installer.yes"));
        UIManager.put("OptionPane.noButtonText", this.installdata.langpack.getString("installer.no"));
        UIManager.put("OptionPane.cancelButtonText", this.installdata.langpack.getString("installer.cancel"));
        String title = this.installdata.langpack.getString("installer.title") + this.installdata.info.getAppName();
        new InstallerFrame(title, this.installdata);
    }

    private static class FlagRenderer
    extends JLabel
    implements ListCellRenderer {
        private TreeMap icons = new TreeMap();
        private TreeMap grayIcons = new TreeMap();

        public FlagRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String iso3 = (String)value;
            this.setText(iso3);
            if (isSelected) {
                this.setForeground(list.getSelectionForeground());
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setForeground(list.getForeground());
                this.setBackground(list.getBackground());
            }
            if (!this.icons.containsKey(iso3)) {
                ImageIcon icon = new ImageIcon(this.getClass().getResource("/res/flag." + iso3));
                this.icons.put(iso3, icon);
                icon = new ImageIcon(GrayFilter.createDisabledImage(icon.getImage()));
                this.grayIcons.put(iso3, icon);
            }
            if (isSelected || index == -1) {
                this.setIcon((ImageIcon)this.icons.get(iso3));
            } else {
                this.setIcon((ImageIcon)this.grayIcons.get(iso3));
            }
            return this;
        }
    }

    private final class LanguageDialog
    extends JDialog
    implements ActionListener {
        private JComboBox comboBox;
        private JButton okButton;

        public LanguageDialog(JFrame frame, Object[] items) {
            super(frame);
            try {
                GUIInstaller.this.loadLookAndFeel();
            }
            catch (Exception err) {
                err.printStackTrace();
            }
            this.addWindowListener(new WindowHandler());
            JPanel contentPane = (JPanel)this.getContentPane();
            this.setTitle("Language selection");
            GridBagLayout layout = new GridBagLayout();
            contentPane.setLayout(layout);
            GridBagConstraints gbConstraints = new GridBagConstraints();
            gbConstraints.anchor = 10;
            gbConstraints.insets = new Insets(5, 5, 5, 5);
            gbConstraints.fill = 0;
            gbConstraints.gridx = 0;
            gbConstraints.weightx = 1.0;
            gbConstraints.weighty = 1.0;
            ImageIcon img = this.getImage();
            JLabel imgLabel = new JLabel(img);
            gbConstraints.gridy = 0;
            contentPane.add(imgLabel);
            gbConstraints.fill = 2;
            JLabel label1 = new JLabel("Please select your language (ISO3 code)", 0);
            gbConstraints.gridy = 1;
            gbConstraints.insets = new Insets(5, 5, 0, 5);
            layout.addLayoutComponent(label1, gbConstraints);
            contentPane.add(label1);
            JLabel label2 = new JLabel("for install instructions:", 0);
            gbConstraints.gridy = 2;
            gbConstraints.insets = new Insets(0, 5, 5, 5);
            layout.addLayoutComponent(label2, gbConstraints);
            contentPane.add(label2);
            gbConstraints.insets = new Insets(5, 5, 5, 5);
            this.comboBox = new JComboBox<Object>(items);
            this.comboBox.setRenderer(new FlagRenderer());
            gbConstraints.fill = 2;
            gbConstraints.gridy = 3;
            layout.addLayoutComponent(this.comboBox, gbConstraints);
            contentPane.add(this.comboBox);
            this.okButton = new JButton("Ok");
            this.okButton.addActionListener(this);
            gbConstraints.fill = 0;
            gbConstraints.gridy = 4;
            gbConstraints.anchor = 10;
            layout.addLayoutComponent(this.okButton, gbConstraints);
            contentPane.add(this.okButton);
            this.getRootPane().setDefaultButton(this.okButton);
            if (System.getProperty("mrj.version") == null) {
                this.pack();
            } else {
                this.setSize(this.getPreferredSize());
            }
            Dimension frameSize = this.getSize();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2 - 10);
            this.setResizable(true);
        }

        public ImageIcon getImage() {
            ImageIcon img;
            try {
                img = new ImageIcon((class$com$izforge$izpack$installer$GUIInstaller$LanguageDialog == null ? (class$com$izforge$izpack$installer$GUIInstaller$LanguageDialog = GUIInstaller.class$("com.izforge.izpack.installer.GUIInstaller$LanguageDialog")) : class$com$izforge$izpack$installer$GUIInstaller$LanguageDialog).getResource("/res/installer.langsel.img"));
            }
            catch (NullPointerException err) {
                img = null;
            }
            return img;
        }

        public Object getSelection() {
            return this.comboBox.getSelectedItem();
        }

        public void setSelection(Object item) {
            this.comboBox.setSelectedItem(item);
        }

        public void actionPerformed(ActionEvent e) {
            this.dispose();
        }

        private class WindowHandler
        extends WindowAdapter {
            private WindowHandler() {
            }

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        }
    }
}

