/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Panel;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsConstraint;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;

public class AutomatedInstaller
extends InstallerBase {
    private TreeMap panelInstanceCount;
    private AutomatedInstallData idata = new AutomatedInstallData();

    public AutomatedInstaller(String inputFilename) throws Exception {
        File input = new File(inputFilename);
        this.loadInstallData(this.idata);
        this.idata.xmlData = this.getXMLData(input);
        this.idata.localeISO3 = this.idata.xmlData.getAttribute("langpack", "eng");
        InputStream in = this.getClass().getResourceAsStream("/langpacks/" + this.idata.localeISO3 + ".xml");
        this.idata.langpack = new LocaleDatabase(in);
        this.idata.setVariable("ISO3_LANG", this.idata.localeISO3);
        ResourceManager.create(this.idata);
        this.panelInstanceCount = new TreeMap();
        this.doInstall(this.idata);
    }

    private void writeUninstallData() {
        try {
            UninstallData udata = UninstallData.getInstance();
            List files = udata.getFilesList();
            ZipOutputStream outJar = this.idata.uninstallOutJar;
            if (outJar == null) {
                return;
            }
            System.out.println("[ Writing the uninstaller data ... ]");
            outJar.putNextEntry(new ZipEntry("install.log"));
            BufferedWriter logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
            logWriter.write(this.idata.getInstallPath());
            logWriter.newLine();
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                logWriter.write((String)iter.next());
                if (!iter.hasNext()) continue;
                logWriter.newLine();
            }
            logWriter.flush();
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("jarlocation.log"));
            logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
            logWriter.write(udata.getUninstallerJarFilename());
            logWriter.newLine();
            logWriter.write(udata.getUninstallerPath());
            logWriter.flush();
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("executables"));
            ObjectOutputStream execStream = new ObjectOutputStream(outJar);
            iter = udata.getExecutablesList().iterator();
            execStream.writeInt(udata.getExecutablesList().size());
            while (iter.hasNext()) {
                ExecutableFile file = (ExecutableFile)iter.next();
                execStream.writeObject(file);
            }
            execStream.flush();
            outJar.closeEntry();
            outJar.flush();
            outJar.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    private void doInstall(AutomatedInstallData installdata) throws Exception {
        System.out.println("[ Starting automated installation ]");
        Iterator panelsIterator = installdata.panelsOrder.iterator();
        while (panelsIterator.hasNext()) {
            Panel p = (Panel)panelsIterator.next();
            String praefix = "com.izforge.izpack.panels.";
            if (p.className.compareTo(".") > -1) {
                praefix = "";
            }
            if (!OsConstraint.oneMatchesCurrentSystem(p.osConstraints)) continue;
            String panelClassName = p.className;
            String automationHelperClassName = praefix + panelClassName + "AutomationHelper";
            Class<?> automationHelperClass = null;
            try {
                automationHelperClass = Class.forName(automationHelperClassName);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            PanelAutomation automationHelperInstance = null;
            if (automationHelperClass != null) {
                try {
                    automationHelperInstance = (PanelAutomation)automationHelperClass.newInstance();
                }
                catch (Exception e) {
                    System.err.println("ERROR: no default constructor for " + automationHelperClassName + ", skipping...");
                    continue;
                }
            }
            Vector panelRoots = installdata.xmlData.getChildrenNamed(panelClassName);
            int panelRootNo = 0;
            if (this.panelInstanceCount.containsKey(panelClassName)) {
                panelRootNo = (Integer)this.panelInstanceCount.get(panelClassName);
            }
            XMLElement panelRoot = (XMLElement)panelRoots.elementAt(panelRootNo);
            this.panelInstanceCount.put(panelClassName, new Integer(panelRootNo + 1));
            if (automationHelperInstance == null) continue;
            try {
                automationHelperInstance.runAutomated(installdata, panelRoot);
            }
            catch (Exception e) {
                System.err.println("ERROR: automated installation failed for panel " + panelClassName);
                e.printStackTrace();
            }
        }
        this.writeUninstallData();
        System.out.println("[ Automated installation done ]");
        Housekeeper.getInstance().shutDown(0);
    }

    public XMLElement getXMLData(File input) throws Exception {
        FileInputStream in = new FileInputStream(input);
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(new StdXMLBuilder());
        parser.setReader(new StdXMLReader(in));
        parser.setValidator(new NonValidator());
        XMLElement rtn = (XMLElement)parser.parse();
        in.close();
        return rtn;
    }
}

