/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.transport;

import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSLogManager;
import com.dls.jpos.transport.DLSUsbInterfacePolicy;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.usb.UsbControlIrp;
import javax.usb.UsbDevice;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbInterfacePolicy;
import javax.usb.UsbServices;
import javax.usb.util.UsbUtil;

public class DLSUsbQuery {
    protected DLSLogManager log = DLSLogManager.getInstance();
    protected UsbInterface theUsbInterface = null;
    protected static final byte HID_CLASS = 3;
    public static final byte HID_DESCRIPTOR_TYPE_REPORT = 34;
    public static final byte GET_REPORT_DESCRIPTOR_REQUESTTYPE = -127;
    public static final byte GET_REPORT_DESCRIPTOR_REQUEST = 6;
    public static final short GET_REPORT_DESCRIPTOR_VALUE = 8704;

    protected boolean validateUsage(UsbInterface usbInterface, DLSDeviceInfo info) {
        boolean bRc = false;
        String strInterface = "";
        try {
            strInterface = usbInterface.getInterfaceString();
        }
        catch (UsbException e) {
        }
        catch (UnsupportedEncodingException f) {
        }
        catch (UsbDisconnectedException g) {
            // empty catch block
        }
        this.log.in(this, "validateUsage: " + strInterface);
        try {
            usbInterface.claim((UsbInterfacePolicy)new DLSUsbInterfacePolicy());
        }
        catch (UsbException e) {
            this.log.error(this, "Error claiming usbInterface: " + e.getMessage());
        }
        UsbDevice usbDevice = usbInterface.getUsbConfiguration().getUsbDevice();
        UsbControlIrp usageIrp = usbDevice.createUsbControlIrp((byte)-127, (byte)6, (short)8704, UsbUtil.unsignedShort((byte)usbInterface.getUsbInterfaceDescriptor().bInterfaceNumber()));
        byte[] data = new byte[256];
        usageIrp.setData(data);
        try {
            usbDevice.syncSubmit(usageIrp);
            if (UsbUtil.unsignedInt((short)UsbUtil.toShort((byte)data[5], (byte)data[4])) == info.getUsage()) {
                bRc = true;
            }
            this.log.trace(this, "bytes returned:" + usageIrp.getActualLength());
            this.log.trace(this, "usage:" + Integer.toHexString(UsbUtil.unsignedInt((short)UsbUtil.toShort((byte)data[5], (byte)data[4]))) + ", usage2:" + Integer.toHexString(UsbUtil.unsignedInt((short)UsbUtil.toShort((byte)data[2], (byte)data[1]))) + ", getUsage():" + Integer.toHexString(info.getUsage()));
        }
        catch (UsbException e) {
            this.log.error(this, "Error getting report type descriptor: " + e.getMessage());
            bRc = false;
        }
        try {
            usbInterface.release();
        }
        catch (UsbException e) {
            this.log.error(this, "Error releasing usbInterface: " + Integer.toHexString(info.getUsage()) + ",msg: " + e.getMessage());
        }
        this.log.out(this, "validateUsage: " + bRc);
        return bRc;
    }

    protected UsbInterface scanHub(UsbDevice device, DLSDeviceInfo info) {
        int i;
        this.theUsbInterface = null;
        if (device.isConfigured() && info.getProductId() == device.getUsbDeviceDescriptor().idProduct() && info.getVendorId() == device.getUsbDeviceDescriptor().idVendor()) {
            List ifaces = device.getActiveUsbConfiguration().getUsbInterfaces();
            this.log.trace(this, "Found product: " + Integer.toHexString(info.getProductId()) + ", vendor: " + Integer.toHexString(info.getVendorId()));
            for (i = 0; i < ifaces.size(); ++i) {
                UsbInterface usbInterface = (UsbInterface)ifaces.get(i);
                if (3 != usbInterface.getUsbInterfaceDescriptor().bInterfaceClass() || !this.validateUsage(usbInterface, info)) continue;
                this.theUsbInterface = usbInterface;
                i = ifaces.size();
                this.log.trace(this, "Interface to product found.");
            }
        }
        if (device.isUsbHub()) {
            List devices = ((UsbHub)device).getAttachedUsbDevices();
            for (i = 0; i < devices.size(); ++i) {
                if (this.theUsbInterface != null) continue;
                this.scanHub((UsbDevice)devices.get(i), info);
            }
        }
        return this.theUsbInterface;
    }

    public UsbInterface findDevice(DLSDeviceInfo info) throws DLSException {
        this.log.in(this, "findDevice");
        UsbServices services = null;
        UsbHub virtualRootHub = null;
        UsbInterface usbInterface = null;
        try {
            this.log.trace(this, "gettingUsbServices");
            services = UsbHostManager.getUsbServices();
            this.log.trace(this, "gettingRootUsbHub");
            virtualRootHub = services.getRootUsbHub();
        }
        catch (UsbException e) {
            throw new DLSException(-2147483647, e.getMessage());
        }
        catch (SecurityException e) {
            throw new DLSException(-2147483646, e.getMessage());
        }
        this.log.trace(this, "Scanning hub");
        usbInterface = this.scanHub((UsbDevice)virtualRootHub, info);
        this.log.out(this, "findDevice returned: " + (usbInterface != null));
        return usbInterface;
    }
}

