/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.transport;

import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSRegistryAccess;
import com.dls.jpos.transport.DLSPort;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TooManyListenersException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DLSSerialPort
extends DLSPort
implements SerialPortEventListener {
    protected InputStream inputStream = null;
    protected OutputStream outputStream = null;
    protected SerialPort serialPort = null;
    protected CommPortIdentifier portId = null;
    protected static final int RECEIVE_THRESHOLD = 1;
    protected static final int RECEIVE_TIMEOUT = 40;
    protected byte[] readBuffer = new byte[2048];
    protected String logData = "";
    protected int nOpens = 0;
    public String strPort;
    static /* synthetic */ Class class$java$lang$System;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public DLSSerialPort(DLSDeviceInfo info) {
        super(info);
    }

    public boolean openPort() {
        block31: {
            this.log.in(this, "openPort");
            this.strPort = this.info.getPortAsString();
            int inPort = 0;
            boolean bFound = false;
            Enumeration portList = null;
            if (this.strPort != null) {
                if (!this.strPort.contains("COM")) {
                    inPort = this.info.getPort();
                }
            } else {
                String[] inports = this.strPort.split("COM");
                if (inports.length > 1) {
                    inPort = Integer.parseInt(inports[1]);
                }
            }
            JavaLibraryPath jp = new JavaLibraryPath();
            String os_type = System.getProperty("os.name").toLowerCase();
            if (os_type.contains("windows")) {
                this.log.trace(this, "windows lib path: " + System.getProperty("user.dir") + ";" + System.getProperty("user.dir") + "\\SupportJars");
                try {
                    jp.add(System.getProperty("user.dir"));
                    jp.add(System.getProperty("user.dir") + "\\SupportJars");
                }
                catch (Exception ex) {
                    this.log.error(this, ex.getLocalizedMessage());
                }
            } else {
                this.log.trace(this, "linux lib path: " + System.getProperty("user.dir") + ":" + System.getProperty("user.dir") + "/SupportJars");
                try {
                    jp.add(System.getProperty("user.dir"));
                    jp.add(System.getProperty("user.dir") + "/SupportJars");
                }
                catch (Exception ex) {
                    this.log.error(this, ex.getLocalizedMessage());
                }
            }
            this.log.trace(this, "Port: " + this.strPort + ", reported from jpos.xml");
            if (this.nOpens == 0) {
                if (this.log.strOS.contains("WINDOWS")) {
                    if (this.info.getUseVirtualPort()) {
                        this.strPort = DLSRegistryAccess.readRegistry("HKLM\\HARDWARE\\DEVICEMAP\\SERIALCOMM", "Virtual");
                        if (this.strPort != null) {
                            this.info.setPortAsString(this.strPort);
                            Pattern p = Pattern.compile("[0-9]+");
                            Matcher m = p.matcher(this.strPort);
                            while (m.find()) {
                                int n;
                                inPort = n = Integer.parseInt(m.group());
                                this.info.setPort(n);
                            }
                        }
                    } else {
                        this.strPort = this.info.getPortAsString();
                    }
                } else if (this.info.getUseCOMxOnLinux()) {
                    this.strPort = this.info.getPortAsString();
                }
                try {
                    portList = CommPortIdentifier.getPortIdentifiers();
                    while (portList.hasMoreElements()) {
                        this.portId = (CommPortIdentifier)portList.nextElement();
                        if (this.portId.getPortType() != 1) continue;
                        String portName = this.portId.getName();
                        if (portName.contains("ttyS") && portName.endsWith(String.valueOf(inPort - 1))) {
                            bFound = true;
                            break;
                        }
                        if (this.info.getUseCOMxOnLinux() && portName.contains("COM") && !this.log.strOS.contains("WINDOWS")) {
                            bFound = true;
                            break;
                        }
                        if (portName.contains("COM") && portName.endsWith(String.valueOf(inPort))) {
                            bFound = true;
                            break;
                        }
                        if (!portName.contains("ACM") || this.info.getUseCOMxOnLinux()) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound) {
                        try {
                            this.serialPort = (SerialPort)this.portId.open("DLSSerialPort", 5000);
                            this.setSerialParms();
                            this.inputStream = this.serialPort.getInputStream();
                            this.outputStream = this.serialPort.getOutputStream();
                            this.serialPort.addEventListener((SerialPortEventListener)this);
                            this.serialPort.notifyOnDataAvailable(true);
                            this.bOpen = true;
                            ++this.nOpens;
                        }
                        catch (UnsupportedCommOperationException ucoe) {
                            this.log.error(this, "UnsupportedCommOperationException: " + ucoe.getMessage());
                        }
                        catch (PortInUseException e) {
                            this.log.error(this, "PortInUseException: " + e.getMessage());
                        }
                        catch (IOException e) {
                            this.log.error(this, "IOException: " + e.getMessage());
                        }
                        catch (TooManyListenersException e) {
                            this.log.error(this, "TooManyListenersException: " + e.getMessage());
                        }
                        break block31;
                    }
                    this.log.error(this, "Port: " + this.strPort + ", not found");
                }
                catch (Exception e) {
                    this.log.error(this, e.getMessage());
                }
            } else {
                ++this.nOpens;
                this.bOpen = true;
            }
        }
        this.log.out(this, "openPort: " + this.bOpen + ", nOpens=" + this.nOpens);
        return this.bOpen;
    }

    public boolean startLiveWeight(byte[] buf, int len, int rate) {
        return false;
    }

    public void stopLiveWeight() {
    }

    public String getPortName() {
        return this.strPort;
    }

    protected void setSerialParms() throws UnsupportedCommOperationException {
        try {
            int nBaud = this.info.getBaud();
            int nData = this.info.getDatabits();
            int nStop = this.info.getStopbits();
            String strParity = this.info.getParity();
            int nParity = 0;
            int flowControl = this.info.getFlowControl().equals("Xon/Xoff") ? 4 : (this.info.getFlowControl().equals("Hardware") ? 1 : 0);
            char bParity = strParity.charAt(0);
            switch (bParity) {
                case 'N': {
                    nParity = 0;
                    break;
                }
                case 'E': {
                    nParity = 2;
                    break;
                }
                case 'O': {
                    nParity = 1;
                    break;
                }
                case 'S': {
                    nParity = 4;
                    break;
                }
                case 'M': {
                    nParity = 3;
                }
            }
            switch (nData) {
                case 5: {
                    nData = 5;
                    break;
                }
                case 6: {
                    nData = 6;
                    break;
                }
                case 7: {
                    nData = 7;
                    break;
                }
                case 8: {
                    nData = 8;
                }
            }
            switch (nStop) {
                case 1: {
                    nStop = 1;
                    break;
                }
                case 2: {
                    nStop = 2;
                }
            }
            this.serialPort.setSerialPortParams(nBaud, nData, nStop, nParity);
            this.serialPort.enableReceiveThreshold(1);
            this.serialPort.enableReceiveTimeout(40);
            this.serialPort.setRTS(true);
        }
        catch (UnsupportedCommOperationException e) {
            this.log.error(this, "UnsupportedCommOperationException: " + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.log.trace(this, "Exception thrown in setSerialParms: " + e.getMessage());
        }
    }

    public void changeBaudRate(int nBaud) {
        try {
            int nData = this.info.getDatabits();
            int nStop = this.info.getStopbits();
            String strParity = this.info.getParity();
            int nParity = 0;
            int flowControl = this.info.getFlowControl().equals("Xon/Xoff") ? 4 : (this.info.getFlowControl().equals("Hardware") ? 1 : 0);
            char bParity = strParity.charAt(0);
            switch (bParity) {
                case 'N': {
                    nParity = 0;
                    break;
                }
                case 'E': {
                    nParity = 2;
                    break;
                }
                case 'O': {
                    nParity = 1;
                    break;
                }
                case 'S': {
                    nParity = 4;
                    break;
                }
                case 'M': {
                    nParity = 3;
                }
            }
            switch (nData) {
                case 5: {
                    nData = 5;
                    break;
                }
                case 6: {
                    nData = 6;
                    break;
                }
                case 7: {
                    nData = 7;
                    break;
                }
                case 8: {
                    nData = 8;
                }
            }
            switch (nStop) {
                case 1: {
                    nStop = 1;
                    break;
                }
                case 2: {
                    nStop = 2;
                }
            }
            this.serialPort.setSerialPortParams(nBaud, nData, nStop, nParity);
            this.serialPort.enableReceiveThreshold(1);
            this.serialPort.enableReceiveTimeout(40);
            this.serialPort.setRTS(true);
        }
        catch (UnsupportedCommOperationException e) {
            this.log.error(this, "UnsupportedCommOperationException: " + e.getMessage());
        }
        catch (Exception e) {
            this.log.trace(this, "Exception thrown in changeBaudRate: " + e.getMessage());
        }
    }

    public boolean closePort() {
        this.log.in(this, "closePort");
        try {
            this.log.log(this, "closePort: nOpens = " + this.nOpens);
            --this.nOpens;
            if (this.nOpens <= 0) {
                this.log.log(this, "closePort: nOpens <= 0 = " + this.nOpens);
                if (this.serialPort != null) {
                    this.log.log(this, "closePort: serialPort != null");
                    this.log.log(this, "closePort: serialPort.getBaudRate() = " + this.serialPort.getBaudRate());
                    this.log.log(this, "closePort: serialPort.getFlowControlMode() = " + this.serialPort.getFlowControlMode());
                    this.log.log(this, "closePort: serialPort.getReceiveThreshold() = " + this.serialPort.getReceiveThreshold());
                    this.log.log(this, "closePort: serialPort.getReceiveTimeout() = " + this.serialPort.getReceiveTimeout());
                    this.log.log(this, "closePort: serialPort.isReceiveFramingEnabled() = " + this.serialPort.isReceiveFramingEnabled());
                    this.log.log(this, "closePort: serialPort.isReceiveThresholdEnabled() = " + this.serialPort.isReceiveThresholdEnabled());
                    this.log.log(this, "closePort: serialPort.isReceiveTimeoutEnabled() = " + this.serialPort.isReceiveTimeoutEnabled());
                    this.serialPort.notifyOnDataAvailable(false);
                    this.log.log(this, "closePort: serialPort.notifyOnDataAvailable(false)");
                    this.inputStream.close();
                    this.log.log(this, "closePort: inputStream.close()");
                    this.outputStream.close();
                    this.log.log(this, "closePort: outputStream.close()");
                    String sysProp = System.getProperty("os.name");
                    if (sysProp.contains("Windows")) {
                        this.serialPort.removeEventListener();
                    }
                    this.log.log(this, "closePort: serialPort.removeEventListener()");
                    this.serialPort.close();
                    this.log.log(this, "closePort: serialPort.close()");
                    this.serialPort = null;
                    this.inputStream = null;
                    this.outputStream = null;
                    this.portId = null;
                }
                this.nOpens = 0;
                this.bOpen = false;
            }
        }
        catch (Exception e) {
            this.log.error(this, "Error closing port: " + e.getMessage());
        }
        this.log.out(this, "closePort");
        return true;
    }

    public int sendData(byte[] buf, int len) {
        int nBytes = buf.length;
        try {
            this.outputStream.write(buf);
            this.logData = "";
            for (int i = 0; i < nBytes; ++i) {
                this.logData = this.logData + " 0x" + Integer.toHexString(buf[i] & 0xFF);
            }
            this.log.trace(this, "bytes sent[" + nBytes + "]" + this.logData);
        }
        catch (IOException e) {
            this.log.error(this, "IOException: " + e.getMessage());
            nBytes = 0;
        }
        return nBytes;
    }

    public boolean isDSR() {
        return this.serialPort.isDSR();
    }

    public void setRTS(boolean bValue) {
        this.serialPort.setRTS(bValue);
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 10: {
                this.log.trace(this, "event.getEventType: BI");
            }
            case 7: {
                this.log.trace(this, "event.getEventType: OE");
            }
            case 9: {
                this.log.trace(this, "event.getEventType: FE");
            }
            case 8: {
                this.log.trace(this, "event.getEventType: PE");
            }
            case 6: {
                this.log.trace(this, "event.getEventType: CD");
            }
            case 3: {
                this.log.trace(this, "event.getEventType: CTS");
            }
            case 4: {
                this.log.trace(this, "event.getEventType: DSR");
            }
            case 5: {
                this.log.trace(this, "event.getEventType: RI");
            }
            case 2: {
                this.log.trace(this, "event.getEventType: OUTPUT_BUFFER_EMPTY");
                break;
            }
            case 1: {
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                try {
                    int numBytes = 0;
                    while (this.inputStream.available() > 0) {
                        numBytes = this.inputStream.read(this.readBuffer);
                        bs.write(this.readBuffer, 0, numBytes);
                    }
                    byte[] bytesRead = bs.toByteArray();
                    this.logData = "";
                    for (int i = 0; i < bytesRead.length; ++i) {
                        this.logData = this.logData + " 0x" + Integer.toHexString(bytesRead[i] & 0xFF);
                    }
                    this.log.trace(this, "bytes received[" + bytesRead.length + "]" + this.logData);
                    this.fireDataReceivedEvent(bytesRead, bytesRead.length);
                    break;
                }
                catch (IOException e) {
                    this.log.error(this, "IOException: " + e.getMessage());
                }
            }
        }
    }

    public class JavaLibraryPath {
        public void add(File path) throws Exception {
            String newLibraryPath = System.getProperty("java.library.path");
            newLibraryPath = newLibraryPath == null || newLibraryPath.length() < 1 ? path.getCanonicalPath() : newLibraryPath + File.pathSeparator + path.getCanonicalPath();
            Field f = (class$java$lang$System == null ? (class$java$lang$System = DLSSerialPort.class$("java.lang.System")) : class$java$lang$System).getDeclaredField("props");
            f.setAccessible(true);
            Properties props = (Properties)f.get(null);
            props.put("java.library.path", newLibraryPath);
            Field usr_pathsField = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = DLSSerialPort.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredField("usr_paths");
            usr_pathsField.setAccessible(true);
            String[] usr_paths = (String[])usr_pathsField.get(null);
            String[] newUsr_paths = new String[usr_paths == null ? 1 : usr_paths.length + 1];
            if (usr_paths != null) {
                System.arraycopy(usr_paths, 0, newUsr_paths, 0, usr_paths.length);
            }
            newUsr_paths[newUsr_paths.length - 1] = path.getAbsolutePath();
            usr_pathsField.set(null, newUsr_paths);
        }

        public void add(String sPath) throws Exception {
            File path = new File(sPath);
            this.add(path);
        }
    }
}

