/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSScannerConfig;
import com.dls.jpos.interpretation.DLSScanner;
import java.io.ByteArrayOutputStream;
import java.util.Hashtable;

public class DLSPortalScanner
extends DLSScanner
implements DLSJposConst {
    protected int CMD_POS = 0;
    protected static final String enableCmd = "e";
    protected static final String enableBeepCmd = "b";
    protected static final String disableCmd = "d";
    protected static final String sleepCmd = "z";
    protected static final String shutdownCmd = "o";
    protected static final String posConnectedMessageCmd = "a";
    protected static final String configureCmd = "c";
    protected static final String resetPortalScannerCmd = "r";
    protected static final String restartPortalScannerCmd = "u";
    protected static final String requestImageCmd = "q";
    protected static final String transactionStateCmd = "t";
    protected static final String signalItemCmd = "s";
    protected static final String identifyItemCmd = "i";
    protected static final String additionalItemScannedCmd = "x";
    protected static final String scannerIdentificationCmd = "k";
    protected static final String deviceStatusCmd = "s";
    protected static final String scannerHealthCmd = "h";
    protected static final String scannerStatisticsCmd = "n";
    protected static final String lightlyCmd = "LIGHTLY";
    protected static final String deeplyCmd = "DEEPLY";
    protected int byte0 = 0;
    protected int byte1 = 0;
    protected int byte2 = 0;
    protected int byte3 = 0;
    protected int nWaitingOnEot = 0;
    protected byte[] sohBuf;
    protected Object objWaitSohBuf = new Object();
    protected boolean bFirmware = false;
    protected boolean bIsEnabled = false;
    protected boolean bStatMessageSent = false;
    public int deviceNumber = 0;
    protected Object objWaitAck = new Object();
    protected Hashtable hTable;
    String decodeType = null;
    static /* synthetic */ Class class$com$dls$jpos$interpretation$DLSPortalScanner$stEnum;

    protected int sendMsg(String msg) {
        return this.port.sendData(msg);
    }

    protected int sendMsg(byte[] msg) {
        return this.port.sendData(msg);
    }

    protected int sendMsgToDevice(String msg, int devNum) {
        return this.port.sendData(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendReceiveMsg(String msg) {
        Object object = this.objWaitSohBuf;
        synchronized (object) {
            this.sohBuf = null;
            int x = this.sendMsg(msg);
            try {
                this.objWaitSohBuf.wait(this.nTimeout);
            }
            catch (InterruptedException ie) {
                this.log.trace(this, "Interrupt exception " + ie);
            }
        }
        return this.sohBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendRecord(String sRecord) {
        this.log.in(this, "sendRecord");
        Object object = this.objWaitAck;
        synchronized (object) {
            this.bFirmware = true;
            this.nResponse = 255;
            int x = this.sendMsg(sRecord);
            try {
                this.objWaitAck.wait(this.nRecordTimeout);
            }
            catch (InterruptedException ie) {
                this.log.trace(this, "Interrupt exception " + ie);
            }
        }
        this.log.out(this, "sendRecord: " + this.nResponse);
        return this.nResponse;
    }

    public void enable() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        int x = this.sendMsg(enableCmd);
        this.bIsEnabled = true;
    }

    public void disable() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        int x = this.sendMsg(disableCmd);
        this.bIsEnabled = true;
    }

    public void reset() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        int x = this.sendMsg(resetPortalScannerCmd);
    }

    public void enableBeep() {
        if (this.log.getFWBusy()) {
            return;
        }
        int x = this.sendMsg(enableBeepCmd);
    }

    public void disableBeep() {
    }

    public void setDeviceNumber(int devNum) {
        this.deviceNumber = devNum;
    }

    public int getDeviceNumber() {
        return this.deviceNumber;
    }

    public boolean getgetDeleteImageFileAfterRead() {
        return this.scannerConfig.getDeleteImageFileAfterRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSelfTest() {
        if (this.log.getFWBusy()) {
            return;
        }
        this.bAlive = true;
        if (this.scannerConfig.getCanAcceptStatisticsCmd()) {
            Object object = this.objWaitSohBuf;
            synchronized (object) {
                this.sohBuf = null;
                this.sendMsg(scannerStatisticsCmd);
                try {
                    this.objWaitSohBuf.wait(this.nTimeout);
                    if (this.sohBuf == null) {
                        this.bAlive = false;
                        this.fireDeviceErrorEvent(-116);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean doHealthCheck() throws DLSException {
        if (this.log.getFWBusy()) {
            return true;
        }
        boolean bRc = true;
        byte[] buf = this.sendReceiveMsg(scannerHealthCmd);
        if (buf != null) {
            this.logHealthCheck(buf);
        } else {
            this.log.error(this, "Timeout on HealthCheck");
            bRc = false;
        }
        return bRc;
    }

    public boolean isAlive() {
        if (this.log.getFWBusy()) {
            return this.bAlive;
        }
        this.doSelfTest();
        return this.bAlive;
    }

    public void setFirmwareBaudRate() {
        this.log.in(this, "setFirmwareBaudRate");
        this.log.out(this, "setFirmwareBaudRate");
    }

    public void restoreBaudRate() {
        this.log.in(this, "restoreBaudRate");
        this.log.out(this, "restoreBaudRate");
    }

    public int sendJoin() {
        return 0;
    }

    public int sendReset() {
        return 0;
    }

    public void updateConfiguration() {
    }

    public DLSScannerConfig reportConfiguration() {
        return this.scannerConfig;
    }

    public void directIO(int command, int[] data, Object object) throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        boolean bWhatState = this.bIsEnabled;
        this.log.in(this, "directIO");
        String strResult = "Invalid Command";
        boolean nResp = false;
        if (this.bIsEnabled) {
            this.disable();
        }
        switch (command) {
            case 1: {
                this.sendMsg(resetPortalScannerCmd);
                strResult = "Scanner reset";
                break;
            }
            case 4: {
                this.sendMsg(configureCmd);
                strResult = "Scanner beeped";
            }
        }
        try {
            ByteArrayOutputStream bsReturn = (ByteArrayOutputStream)object;
            bsReturn.reset();
            if (bsReturn instanceof ByteArrayOutputStream) {
                bsReturn.write(strResult.getBytes());
            } else {
                object = strResult;
            }
        }
        catch (Exception e) {
            this.log.error(this, "Unable to return data to DIO caller - Are you passing in a ByteArrayOuputStream object?");
            object = strResult;
        }
        if (bWhatState) {
            this.enable();
        }
        this.log.out(this, "directIO");
    }

    public boolean hasStatisticsReporting() {
        return this.scannerConfig.getCanAcceptStatisticsCmd();
    }

    public Hashtable getStatistics() throws DLSException {
        String truncated2;
        String truncated;
        this.log.in(this, "getStatistics");
        Hashtable<String, String> table = new Hashtable<String, String>();
        String put = table.put(DLS_S_GOOD_SCAN_COUNT, "NA");
        if (this.log.getFWBusy()) {
            return table;
        }
        if (!this.scannerConfig.getCanAcceptStatisticsCmd()) {
            return table;
        }
        String[] strInfo = null;
        String str = null;
        int i = 0;
        this.log.log(this, "Getting idRequestCmd");
        this.bStatMessageSent = true;
        byte[] buf = this.sendReceiveMsg(scannerStatisticsCmd);
        String logData = "";
        for (i = 0; i < buf.length; ++i) {
            logData = logData + " 0x" + Integer.toHexString(buf[i] & 0xFF);
        }
        this.log.log(this, "# bytes received[" + buf.length + "]" + logData);
        put = table.put("RawInfo", "# bytes received[" + buf.length + "]" + logData);
        if (buf != null && buf.length != 0) {
            strInfo = this.splitMessage(buf);
            block44: for (i = 0; i < strInfo.length; ++i) {
                str = strInfo[i];
                truncated = str.replaceAll("\\p{Cntrl}", "");
                truncated2 = truncated.replaceAll("Sp<", "");
                if (truncated2.length() <= 1) continue;
                switch (truncated2.charAt(0)) {
                    case 'M': {
                        put = table.put(DLS_S_MODEL_NAME, truncated2.substring(1));
                        continue block44;
                    }
                    case 'S': {
                        put = table.put(DLS_S_SERIAL_NUMBER, truncated2.substring(1));
                        continue block44;
                    }
                    case 'm': {
                        put = table.put(DLS_S_SCANNER_BOARD_SERIAL, truncated2.substring(1));
                        continue block44;
                    }
                    case 'A': {
                        put = table.put(DLS_S_FIRMWARE_VERSION, truncated2.substring(1));
                        continue block44;
                    }
                    case 'R': {
                        put = table.put(DLS_S_SCANNER_REVISION, truncated2.substring(1));
                        continue block44;
                    }
                    case 'C': {
                        put = table.put(DLS_S_SCANNER_CONFIG_FILE_ID, truncated2.substring(1));
                        continue block44;
                    }
                    case 'B': {
                        put = table.put(DLS_S_SCANNER_BOOT_ROM_ID, truncated2.substring(1));
                        continue block44;
                    }
                    case 'H': {
                        put = table.put(DLS_S_HARDWARE_ID, truncated2.substring(1));
                        continue block44;
                    }
                    case 'U': {
                        put = table.put(DLS_S_UNIVERSAL_ROM_ID, truncated2.substring(1));
                        continue block44;
                    }
                    case 'u': {
                        put = table.put(DLS_S_UNIVERSAL_BOOT_ROM_ID, truncated2.substring(1));
                        continue block44;
                    }
                    case 'W': {
                        put = table.put(DLS_S_SCALE_INFO, truncated2.substring(1));
                        continue block44;
                    }
                    case 'D': {
                        put = table.put(DLS_S_DISPLAY_VERSION, truncated2.substring(1));
                        continue block44;
                    }
                    case 'E': {
                        put = table.put(DLS_S_EAS_VERSION, truncated2.substring(1));
                        continue block44;
                    }
                    case 'I': {
                        put = table.put(DLS_S_SCANNER_INTERFACE, truncated2.substring(1));
                        continue block44;
                    }
                    case 'r': {
                        put = table.put(DLS_SECONDARY_RADIO_VERSION, truncated2.substring(1));
                        continue block44;
                    }
                    case 'L': {
                        put = table.put(DLS_SECONDARY_RADIO_APP_VERSION, truncated2.substring(1));
                        continue block44;
                    }
                    case 'b': {
                        put = table.put(DLS_SECONDARY_RADIO_BOOTLOADER_VERSION, truncated2.substring(1));
                        continue block44;
                    }
                    case 'X': {
                        put = table.put(DLS_SECONDARY_MODEL_NAME, truncated2.substring(1));
                    }
                }
            }
        }
        this.log.log(this, "Getting healthRequestCmd");
        this.bStatMessageSent = true;
        buf = this.sendReceiveMsg(scannerHealthCmd);
        logData = "";
        for (i = 0; i < buf.length; ++i) {
            logData = logData + " 0x" + Integer.toHexString(buf[i] & 0xFF);
        }
        this.log.log(this, "# bytes received[" + buf.length + "]" + logData);
        put = table.put("RawHealth", "# bytes received[" + buf.length + "]" + logData);
        if (buf != null && buf.length != 0) {
            strInfo = this.splitMessage(buf);
            block46: for (i = 0; i < strInfo.length; ++i) {
                str = strInfo[i];
                truncated = str.replaceAll("\\p{Cntrl}", "");
                truncated2 = truncated.replaceAll("Sp<", "");
                if (truncated2.length() <= 1) continue;
                switch (truncated2.charAt(0)) {
                    case 'm': {
                        put = table.put(DLS_S_MOTOR_HEALTH, truncated2.substring(1));
                        continue block46;
                    }
                    case 'h': {
                        put = table.put(DLS_S_V_LASER_HEALTH, truncated2.substring(1));
                        continue block46;
                    }
                    case 'v': {
                        put = table.put(DLS_S_H_LASER_HEALTH, truncated2.substring(1));
                        continue block46;
                    }
                    case 's': {
                        put = table.put(DLS_S_SCALE_HEALTH, truncated2.substring(1));
                        continue block46;
                    }
                    case 'd': {
                        put = table.put(DLS_S_REMOTE_DISPLAY_HEALTH, truncated2.substring(1));
                        continue block46;
                    }
                    case 'e': {
                        put = table.put(DLS_S_EAS_HEALTH, truncated2.substring(1));
                        continue block46;
                    }
                    case 'c': {
                        put = table.put(DLS_S_CAMERA_HEALTH, truncated2.substring(1));
                        continue block46;
                    }
                    case 'r': {
                        put = table.put(DLS_HH_RADIO_HEALTH, truncated2.substring(1));
                    }
                }
            }
        }
        this.log.log(this, "Getting statisticsCmd");
        this.bStatMessageSent = true;
        buf = this.sendReceiveMsg("s");
        logData = "";
        for (i = 0; i < buf.length; ++i) {
            logData = logData + " 0x" + Integer.toHexString(buf[i] & 0xFF);
        }
        this.log.log(this, "# bytes received[" + buf.length + "]" + logData);
        put = table.put("RawStats", "# bytes received[" + buf.length + "]" + logData);
        if (buf != null && buf.length != 0) {
            strInfo = this.splitMessage(buf);
            block48: for (i = 0; i < strInfo.length; ++i) {
                str = strInfo[i];
                truncated = str.replaceAll("\\p{Cntrl}", "");
                truncated2 = truncated.replaceAll("Sp<", "");
                if (truncated2.length() <= 1) continue;
                switch (truncated2.charAt(0)) {
                    case 'P': {
                        put = table.put(DLS_S_HOURS_POWERED_COUNT, truncated2.substring(1));
                        continue block48;
                    }
                    case 'm': {
                        put = table.put(DLS_S_MOTOR_TIME, truncated2.substring(1));
                        continue block48;
                    }
                    case 'l': {
                        put = table.put(DLS_S_LASER_TIME, truncated2.substring(1));
                        continue block48;
                    }
                    case 'L': {
                        put = table.put(DLS_S_GOOD_SCAN_COUNT, truncated2.substring(1));
                        continue block48;
                    }
                    case 'z': {
                        put = table.put(DLS_S_SCALE_ZEROS, truncated2.substring(1));
                        continue block48;
                    }
                    case 'c': {
                        put = table.put(DLS_S_SCALE_CALS, truncated2.substring(1));
                        continue block48;
                    }
                    case 'E': {
                        put = table.put(DLS_S_EAS_DEACTIVATED, truncated2.substring(1));
                        continue block48;
                    }
                    case 'e': {
                        put = table.put(DLS_S_EAS_MANUAL, truncated2.substring(1));
                        continue block48;
                    }
                    case 'B': {
                        put = table.put(DLS_SECONDARY_BATTERY_CHG_CYCLES, truncated2.substring(1));
                        continue block48;
                    }
                    case 'T': {
                        put = table.put(DLS_SECONDARY_TRIGGER_PULLS, truncated2.substring(1));
                        continue block48;
                    }
                    case 'K': {
                        put = table.put(DLS_SECONDARY_KEY_PRESSES, truncated2.substring(1));
                    }
                }
            }
        }
        if (!table.contains(DLS_S_INTERFACE)) {
            put = table.put(DLS_S_INTERFACE, "RS232");
        }
        put = table.put(DLS_S_MANUFACTURE_NAME, "DLA");
        put = table.put(DLS_S_DEVICE_CATEGORY, "Scanner");
        this.bStatMessageSent = false;
        this.hTable = table;
        return table;
    }

    public Hashtable returnStatistics() throws DLSException {
        return this.hTable;
    }

    protected void parseReadConfigMessages(byte[] inBuf, byte endChar) {
        for (int i = 0; i < inBuf.length; ++i) {
            this.bs.write(inBuf[i]);
            if (inBuf[i] != endChar) continue;
            byte[] tmpBuf = this.bs.toByteArray();
            boolean add = this.msgList.add(tmpBuf);
            this.bs.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataReceived(byte[] inBuf, int inLen) {
        stEnum inState = stEnum.ST_IDLE;
        int nType = 0;
        byte[] scanData = null;
        byte[] scanDataLabel = null;
        String labelStr = "";
        if (this.bFirmware) {
            this.log.in(this, "onDataReceived");
            Object object = this.objWaitAck;
            synchronized (object) {
                this.nResponse = inBuf[0];
                this.bFirmware = false;
                this.log.out(this, "onDataReceived:" + this.nResponse);
                this.objWaitAck.notify();
                return;
            }
        }
        switch (inBuf[0]) {
            case 73: {
                inState = stEnum.ST_ITEM;
                break;
            }
            case 66: {
                inState = stEnum.ST_LABEL;
                int msgLen = inBuf[1];
                msgLen = 256 * msgLen + inBuf[2];
                msgLen = 256 * msgLen + inBuf[3];
                msgLen = 256 * msgLen + inBuf[4];
                int itemID = 0xFF & inBuf[5];
                itemID = 256 * itemID + inBuf[6];
                itemID = 256 * itemID + inBuf[7];
                itemID = 256 * itemID + inBuf[8];
                int imageID = 0xFF & inBuf[9];
                imageID = 256 * imageID + inBuf[10];
                imageID = 256 * imageID + inBuf[11];
                imageID = 256 * imageID + inBuf[12];
                byte labelFormat = inBuf[13];
                int labelLength = 0xFF & inBuf[14];
                labelLength = 256 * labelLength + inBuf[15];
                scanData = new byte[labelLength];
                System.arraycopy(inBuf, 16, scanData, 0, labelLength);
                nType = this.extractBarcodeType(scanData[1], scanData[2]);
                labelStr = new String(scanData);
                inState = stEnum.ST_IDLE;
                this.log.log(this, "Label Data: " + itemID + "  Format:" + labelFormat + "  Len:" + labelLength + "  Data:" + labelStr);
                scanDataLabel = new byte[labelLength - 2];
                System.arraycopy(scanData, 3, scanDataLabel, 0, labelLength - 3);
                if (labelFormat == 0) {
                    switch (nType) {
                        case 101: {
                            if (scanDataLabel.length <= 12) break;
                            nType = 111;
                            break;
                        }
                        case 102: {
                            if (scanDataLabel.length > 8) {
                                nType = 112;
                            }
                            if (scanDataLabel.length == 8) {
                                nType = 103;
                            }
                            if (scanDataLabel.length == 9) {
                                nType = 103;
                            }
                            if (scanDataLabel.length == 12) {
                                nType = 101;
                            }
                            if (scanDataLabel.length == 13) {
                                nType = 101;
                            }
                            if (scanDataLabel.length != 14) break;
                            nType = 104;
                            break;
                        }
                        case 103: {
                            if (scanDataLabel.length <= 8) break;
                            nType = 118;
                            break;
                        }
                        case 104: {
                            if (scanDataLabel.length <= 13) break;
                            nType = 119;
                        }
                    }
                }
                if (labelFormat == 1) {
                    nType = 0;
                }
                DLSProperties options = DLSProperties.getInstance();
                this.bSendCookedData = options.get("com.dls.jpos.service.ScannerService.sendCookedData", false);
                if (this.bSendCookedData) {
                    scanData = scanDataLabel;
                }
                this.fireLabelReceivedEvent(scanDataLabel, scanData, nType);
                break;
            }
            case 65: {
                inState = stEnum.ST_ACK;
                break;
            }
            case 85: {
                inState = stEnum.ST_UPDATE_ITEM;
                break;
            }
            case 79: {
                inState = stEnum.ST_LABEL_CHOICE;
                break;
            }
            case 76: {
                inState = stEnum.ST_LOC;
                break;
            }
            case 86: {
                inState = stEnum.ST_VOL;
                break;
            }
            case 84: {
                inState = stEnum.ST_TRACKING;
                break;
            }
            case 70: {
                inState = stEnum.ST_FAULT;
                break;
            }
            case 80: {
                inState = stEnum.ST_PIC;
                break;
            }
            case 67: {
                inState = stEnum.ST_CONNECTED;
                String inStr = new String(inBuf);
                String connectMsg = "";
                connectMsg = connectMsg + posConnectedMessageCmd;
                String ibuf = this.deviceInfo.getImageBuffers();
                String lbuf = this.deviceInfo.getLaneNumber();
                String jbuf = this.deviceInfo.getJposVersion();
                String servVer = this.deviceInfo.getServiceVersion();
                int iMessageLen = ibuf.length() + lbuf.length() + jbuf.length() + servVer.length();
                byte[] bMessage = new byte[iMessageLen + 3];
                connectMsg = connectMsg + bMessage.length + ibuf + lbuf + jbuf + servVer;
                bMessage = connectMsg.getBytes();
                this.sendMsg(bMessage);
                break;
            }
            default: {
                inState = stEnum.ST_IDLE;
            }
        }
        if (inState != stEnum.ST_CONNECTED && inState != stEnum.ST_ACK) {
            this.fireItemReceivedEvent(inBuf);
        }
    }

    public static byte[] stringToBytesUTFCustom(String str) {
        char[] buffer = str.toCharArray();
        byte[] b = new byte[buffer.length << 1];
        for (int i = 0; i < buffer.length; ++i) {
            int bpos = i << 1;
            b[bpos] = (byte)((buffer[i] & 0xFF00) >> 8);
            b[bpos + 1] = (byte)(buffer[i] & 0xFF);
        }
        return b;
    }

    private static void hostGetLabel(byte[] inBuf) {
        String labelStr = "";
    }

    private static void hostGetLabelChoice() {
        String labelStr = "";
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class stEnum
    extends Enum<stEnum> {
        public static final stEnum ST_IDLE = new stEnum("ST_IDLE", 0);
        public static final stEnum ST_SIG1 = new stEnum("ST_SIG1", 1);
        public static final stEnum ST_ACK = new stEnum("ST_ACK", 2);
        public static final stEnum ST_ITEM = new stEnum("ST_ITEM", 3);
        public static final stEnum ST_PIC = new stEnum("ST_PIC", 4);
        public static final stEnum ST_LABEL = new stEnum("ST_LABEL", 5);
        public static final stEnum ST_LOC = new stEnum("ST_LOC", 6);
        public static final stEnum ST_VOL = new stEnum("ST_VOL", 7);
        public static final stEnum ST_TRACKING = new stEnum("ST_TRACKING", 8);
        public static final stEnum ST_FAULT = new stEnum("ST_FAULT", 9);
        public static final stEnum ST_CONNECTED = new stEnum("ST_CONNECTED", 10);
        public static final stEnum ST_UPDATE_ITEM = new stEnum("ST_UPDATE_ITEM", 11);
        public static final stEnum ST_LABEL_CHOICE = new stEnum("ST_LABEL_CHOICE", 12);
        public static final stEnum ST_OTHER = new stEnum("ST_OTHER", 13);
        private static final /* synthetic */ stEnum[] $VALUES;

        public static stEnum[] values() {
            return (stEnum[])$VALUES.clone();
        }

        public static stEnum valueOf(String name) {
            return (stEnum)((Object)Enum.valueOf(class$com$dls$jpos$interpretation$DLSPortalScanner$stEnum == null ? (class$com$dls$jpos$interpretation$DLSPortalScanner$stEnum = DLSPortalScanner.class$("com.dls.jpos.interpretation.DLSPortalScanner$stEnum")) : class$com$dls$jpos$interpretation$DLSPortalScanner$stEnum, name));
        }

        private stEnum() {
        }

        static {
            $VALUES = new stEnum[]{ST_IDLE, ST_SIG1, ST_ACK, ST_ITEM, ST_PIC, ST_LABEL, ST_LOC, ST_VOL, ST_TRACKING, ST_FAULT, ST_CONNECTED, ST_UPDATE_ITEM, ST_LABEL_CHOICE, ST_OTHER};
        }
    }
}

