/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.common;

import com.dls.jpos.common.DLSProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DLSLogManager {
    private static DLSLogManager sm_instance;
    public final int levelErrors = 1;
    public final int levelLog = 2;
    public final int levelTrace = 3;
    public final int levelFlow = 4;
    private int traceLevel = 4;
    private int logFiles = 5;
    private FileWriter outFile;
    private String strLastLogDate;
    private String strCurLogDate;
    private String strLogFile;
    public String strLogFileDir = null;
    private boolean bTraceSource = true;
    private int nWrites = 0;
    private int nFlush = 1;
    private String strTmp;
    private boolean bTrimSource = true;
    public String strOS = null;
    public String strOSVER = null;
    public double dVer = 0.0;
    public String strJVMVER = null;
    public double dJVMVer = 0.0;
    private DateFormat dateFormat = new SimpleDateFormat("MM/dd/yy hh:mm:ss.SSS");
    private int nSizeCheckWrites = 0;
    private int nMaxFileSize = 50;
    private boolean bRotateFiles = false;
    private boolean bFWBusy = false;
    private int nUpdatePercentage = 5;

    private DLSLogManager() {
        this.strOS = System.getProperty("os.name");
        this.strOS = this.strOS.toUpperCase();
        if (this.strOS.contains("WINDOWS")) {
            this.strOSVER = System.getProperty("os.version");
            Float f = new Float(this.strOSVER);
            this.dVer = f.doubleValue();
            this.strJVMVER = System.getProperty("java.class.version");
            Float fjvm = new Float(this.strJVMVER);
            this.dJVMVer = fjvm.doubleValue();
        }
    }

    private void log(String strInd, Object obj, int nLevel, String msg) {
        if (this.traceLevel >= nLevel && this.outFile != null) {
            this.strCurLogDate = this.dateFormat.format(new Date());
            this.bRotateFiles = false;
            if (this.strCurLogDate.substring(0, 8).compareTo(this.strLastLogDate.substring(0, 8)) != 0) {
                this.bRotateFiles = true;
            }
            if (this.nSizeCheckWrites >= 500 || this.nSizeCheckWrites == 0) {
                this.nSizeCheckWrites = 0;
                File f = new File(this.strLogFile);
                if (f.length() > (long)(this.nMaxFileSize * 0x100000)) {
                    this.bRotateFiles = true;
                }
            }
            if (this.bRotateFiles) {
                try {
                    this.outFile.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.rotateLogFiles();
                try {
                    this.outFile = new FileWriter(this.strLogFile, true);
                }
                catch (IOException e) {
                    System.out.print("Error creating log file.");
                }
            }
            ++this.nSizeCheckWrites;
            try {
                if (this.bTraceSource) {
                    if (obj != null) {
                        this.strTmp = obj.getClass().getName();
                        if (this.bTrimSource) {
                            this.strTmp = this.strTmp.substring(this.strTmp.lastIndexOf(46) + 1);
                        }
                    } else {
                        this.strTmp = "";
                    }
                    msg = this.strTmp + ": " + msg;
                }
                this.outFile.write(this.strCurLogDate + " " + strInd + " " + msg + "\r\n");
                ++this.nWrites;
                if (this.nFlush > 0 && this.nWrites >= this.nFlush) {
                    this.outFile.flush();
                    this.nWrites = 0;
                }
            }
            catch (IOException e) {
                System.out.print("Error writing to log file");
            }
            this.strLastLogDate = this.strCurLogDate;
        }
    }

    public synchronized void error(Object obj, String msg) {
        if (this.traceLevel >= 1) {
            this.log("*ERR*", obj, 1, msg);
        }
    }

    public synchronized void log(Object obj, String msg) {
        if (this.traceLevel >= 2) {
            this.log("^", obj, 3, msg);
        }
    }

    public synchronized void trace(Object obj, String msg) {
        if (this.traceLevel >= 3) {
            this.log("=", obj, 3, msg);
        }
    }

    public synchronized void in(Object obj, String methodName) {
        if (this.traceLevel >= 4) {
            this.log("+", obj, 4, methodName);
        }
    }

    public synchronized void out(Object obj, String methodName) {
        if (this.traceLevel >= 4) {
            this.log("-", obj, 4, methodName);
        }
    }

    public synchronized boolean getFWBusy() {
        return this.bFWBusy;
    }

    public synchronized void setFWBusy(boolean bBusy) {
        this.bFWBusy = bBusy;
    }

    public synchronized int getUpdatePercentage() {
        return this.nUpdatePercentage;
    }

    private void openLog() {
        try {
            DLSProperties options = DLSProperties.getInstance();
            this.nMaxFileSize = options.get("com.dls.jpos.common.LogManager.MaxFileSizeInMegabytes", 50);
            String strTemp = options.get("com.dls.jpos.common.LogManager.TraceLevel", "4");
            try {
                this.traceLevel = Integer.parseInt(strTemp);
            }
            catch (NumberFormatException e) {
                this.traceLevel = 4;
            }
            strTemp = options.get("com.dls.jpos.common.LogManager.LogFilesToKeep", "5");
            try {
                this.logFiles = Integer.parseInt(strTemp);
            }
            catch (NumberFormatException e) {
                this.logFiles = 5;
            }
            strTemp = options.get("com.dls.jpos.common.LogManager.NumberOfWritesBeforeFlush", "1");
            try {
                this.nFlush = Integer.parseInt(strTemp);
            }
            catch (NumberFormatException e) {
                this.nFlush = 1;
            }
            strTemp = options.get("com.dls.jpos.common.LogManager.TraceSourceName", "true").toUpperCase();
            this.bTraceSource = strTemp.compareTo("TRUE") == 0 || strTemp.compareTo("1") == 0;
            strTemp = options.get("com.dls.jpos.common.LogManager.TrimSourceName", "true").toUpperCase();
            this.bTrimSource = strTemp.compareTo("TRUE") == 0 || strTemp.compareTo("1") == 0;
            if (this.dVer >= 6.0 && this.strOS.contains("WINDOWS")) {
                if (this.dJVMVer >= 49.0) {
                    this.strLogFileDir = System.getenv("APPDATA") + "/";
                    this.strLogFile = this.strLogFileDir + options.get("com.dls.jpos.common.LogManager.LogFile", "jpostrace.log");
                } else {
                    Process p = Runtime.getRuntime().exec("cmd.exe /c echo %APPDATA%");
                    BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    this.strLogFileDir = br.readLine();
                    this.strLogFile = this.strLogFileDir + options.get("com.dls.jpos.common.LogManager.LogFile", "jpostrace.log");
                }
            } else {
                this.strLogFile = options.get("com.dls.jpos.common.LogManager.LogFile", "jpostrace.log");
            }
            this.nUpdatePercentage = options.get("com.dls.jpos.common.LogManager.UpdatePercentage", 5);
        }
        catch (Exception e) {
            System.out.print("Exception in openlog: " + e.getMessage());
        }
        try {
            FileReader inFile = new FileReader(this.strLogFile);
            char[] b = new char[8];
            int bytes = inFile.read(b, 0, 8);
            inFile.close();
            String strInDate = String.copyValueOf(b);
            if (strInDate.compareTo(this.strCurLogDate.substring(0, 8)) != 0) {
                this.rotateLogFiles();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.outFile = new FileWriter(this.strLogFile, true);
            try {
                if (this.strOS.indexOf("WINDOWS") < 0) {
                    Runtime.getRuntime().exec("chmod 666 " + this.strLogFile);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.strLastLogDate = this.strCurLogDate = this.dateFormat.format(new Date());
            this.outFile.write(this.strCurLogDate + "\r\n***********************************************************\r\n\r\n");
        }
        catch (IOException e) {
            this.outFile = null;
        }
    }

    private void rotateLogFiles() {
        int period = this.strLogFile.lastIndexOf(46);
        String strRoot = this.strLogFile.substring(0, period);
        String strExt = this.strLogFile.substring(period + 1);
        new File(strRoot + Integer.toString(this.logFiles) + "." + strExt).delete();
        for (int i = this.logFiles; i > 1; --i) {
            String strFile1 = strRoot + Integer.toString(i - 1) + "." + strExt;
            String strFile2 = strRoot + Integer.toString(i) + "." + strExt;
            new File(strFile1).renameTo(new File(strFile2));
        }
        new File(this.strLogFile).renameTo(new File(strRoot + Integer.toString(1) + "." + strExt));
    }

    public static synchronized DLSLogManager getInstance() {
        if (sm_instance == null) {
            sm_instance = new DLSLogManager();
            DLSLogManager.sm_instance.strCurLogDate = DLSLogManager.sm_instance.dateFormat.format(new Date());
            sm_instance.openLog();
        }
        return sm_instance;
    }
}

