/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.dls.jpos.service.DLSBaseService;
import com.izforge.izpack.Info;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DLSHelloPanel
extends IzPanel {
    private BoxLayout layout;
    private JLabel welcomeLabel;
    private JLabel appAuthorsLabel;
    private JLabel appURLLabel;

    public DLSHelloPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
        DLSBaseService pbs = new DLSBaseService();
        int version = pbs.getVersion();
        int major = version / 1000000;
        int minor = version / 1000 % 1000;
        int build = version % 1000;
        idata.info.setAppVersion("" + major + "." + minor + "." + build);
        this.showPanel(parent, idata);
    }

    public void showPanel(InstallerFrame parent, InstallData idata) {
        GridBagLayout superLayout = new GridBagLayout();
        this.setLayout(superLayout);
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(0, 0, 0, 0);
        gbConstraints.fill = 0;
        gbConstraints.anchor = 10;
        JPanel centerPanel = new JPanel();
        this.layout = new BoxLayout(centerPanel, 1);
        centerPanel.setLayout(this.layout);
        superLayout.addLayoutComponent(centerPanel, gbConstraints);
        this.add(centerPanel);
        centerPanel.add(Box.createVerticalStrut(10));
        String str = parent.langpack.getString("HelloPanel.welcome1") + idata.info.getAppName() + " " + idata.info.getAppVersion();
        this.welcomeLabel = LabelFactory.create(str, parent.icons.getImageIcon("host"), 11);
        centerPanel.add(this.welcomeLabel);
        centerPanel.add(Box.createVerticalStrut(20));
        ArrayList authors = idata.info.getAuthors();
        int size = authors.size();
        if (size > 0) {
            str = parent.langpack.getString("HelloPanel.authors");
            this.appAuthorsLabel = LabelFactory.create(str, parent.icons.getImageIcon("information"), 11);
            centerPanel.add(this.appAuthorsLabel);
            for (int i = 0; i < size; ++i) {
                Info.Author a = (Info.Author)authors.get(i);
                String email = a.getEmail() != null ? " " + a.getEmail() + " " : "";
                JLabel label = LabelFactory.create(" - " + a.getName() + email, parent.icons.getImageIcon("empty"), 11);
                centerPanel.add(label);
            }
            centerPanel.add(Box.createVerticalStrut(20));
        }
        if (idata.info.getAppURL() != null) {
            str = parent.langpack.getString("HelloPanel.url") + idata.info.getAppURL();
            this.appURLLabel = LabelFactory.create(str, parent.icons.getImageIcon("bookmark"), 11);
            centerPanel.add(this.appURLLabel);
        }
    }
}

