/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSScannerConfig;
import com.dls.jpos.interpretation.DLSScanner;
import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import java.util.Iterator;

public class DLSUSBScanner
extends DLSScanner
implements DLSJposConst {
    protected static final byte[] enableCmd = new byte[]{17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected static final byte[] disableCmd = new byte[]{18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected static final byte[] resetCmd = new byte[]{0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected static final byte[] statusCmd = new byte[]{0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected static final byte[] reportConfigCmd = new byte[]{33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected byte[] configCmd = new byte[]{32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected static final byte[] reportConfig2LabelCmd = new byte[]{52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected byte[] config2LabelCmd = new byte[]{35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected static final byte[] enableBeepCmd = new byte[]{20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected static final byte[] disableBeepCmd = new byte[]{24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected static final byte[] doSelfTestCmd = new byte[]{0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected byte[] directIOCmd = new byte[]{48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected static final byte[] statusRequestCmd = new byte[]{0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected boolean bLocalAlive = false;
    protected boolean bEnabled = false;
    protected boolean bRaiseBusy = true;
    protected static final int RESP_FIRMWARE_FLASH = 1;
    protected static final int RESP_CONFIG_DATA = 2;
    protected static final int RESP_EANJANCONFIG_DATA = 4;
    protected static final int RESP_HARDWARE_ERROR = 32;
    protected static final int RESP_DIO_DATA = 64;
    protected static final int RESP_NOT_READY = 128;
    protected static final int RESP_ALIVE = 256;
    protected static final int RESP_ENABLED = 512;
    protected static final int RESP_CHECKDIGIT_ERROR = 1024;
    protected static final int RESP_CMD_REJECT = 32768;
    protected static final int identificationCmd = 1;
    protected static final int healthCmd = 2;
    protected static final int statisticsCmd = 3;
    protected static final int RESP_CONFIG_SUCCESS = 65536;
    protected static final int RESP_CONFIG_COERCED = 131072;
    protected static final int RESP_EANJANCONFIG_SUCCESS = 262144;
    protected static final int RESP_DIO_SUCCESS = 524288;
    protected static final int RESP_DIO_NOT_ALLOWED = 0x100000;
    protected static final int RESP_DIO_UNDEFINED = 0x200000;
    protected final Object reportResp = new Object();
    protected byte[] reportBuf = null;
    protected final Object statusResp = new Object();
    protected byte[] statusBuf = null;
    protected final Object dioResp = new Object();
    protected byte[] dioBuf = null;
    protected boolean bInternalDIO = false;
    protected boolean bReattachPending = true;
    protected byte nStat1;
    protected byte nStat2;
    protected byte nStat3;
    protected final Object objStatus = new Object();
    protected Hashtable hTable;
    protected boolean bStatMessageSent = false;

    public void enable() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.port.sendData(enableCmd, enableCmd.length);
    }

    public void disable() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.port.sendData(disableCmd, disableCmd.length);
    }

    public void reset() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.log.in(this, "reset");
        this.bReattachPending = true;
        this.port.sendData(resetCmd, resetCmd.length);
        this.log.out(this, "reset");
    }

    public void setFirmwareBaudRate() {
    }

    public void restoreBaudRate() {
    }

    public int sendJoin() {
        return 0;
    }

    public int sendReset() {
        return 0;
    }

    public void enableBeep() {
        if (this.log.getFWBusy()) {
            return;
        }
        this.port.sendData(enableBeepCmd, enableBeepCmd.length);
    }

    public void disableBeep() {
        if (this.log.getFWBusy()) {
            return;
        }
        this.port.sendData(disableBeepCmd, disableBeepCmd.length);
    }

    public void doSelfTest() {
        if (this.log.getFWBusy()) {
            return;
        }
        this.port.sendData(doSelfTestCmd, doSelfTestCmd.length);
    }

    public int sendRecord(String sRecord) {
        return 255;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doInternalDirectIO(byte cmd) {
        byte[] buf = null;
        if (this.log.getFWBusy()) {
            return buf;
        }
        try {
            ByteArrayOutputStream bStream = new ByteArrayOutputStream();
            Object object = this.dioResp;
            synchronized (object) {
                this.bInternalDIO = true;
                this.directIOCmd[1] = 0;
                this.directIOCmd[2] = cmd;
                this.dioBuf = null;
                this.port.sendData(this.directIOCmd, this.directIOCmd.length);
                try {
                    do {
                        this.bInternalDIO = true;
                        this.dioBuf = null;
                        this.dioResp.wait(300L);
                        if (this.dioBuf == null) continue;
                        bStream.write(this.dioBuf, 5, this.dioBuf.length - 5);
                    } while (this.dioBuf != null);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            buf = bStream.toByteArray();
        }
        catch (Exception e) {
            String str = e.getMessage();
            this.log.error(this, "doInternalDirectIO exception: " + e.getMessage());
        }
        this.bInternalDIO = false;
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doHealthCheck() throws DLSException {
        if (this.log.getFWBusy()) {
            return true;
        }
        this.log.in(this, "doHealthCheck");
        boolean bRc = true;
        Object object = this.dioResp;
        synchronized (object) {
            this.dioBuf = this.doInternalDirectIO((byte)2);
            if (this.dioBuf != null) {
                this.logHealthCheck(this.dioBuf);
            } else {
                this.log.error(this, "Timeout on directio HealthCheck");
                bRc = false;
            }
        }
        this.log.out(this, "doHealthCheck");
        return bRc;
    }

    public boolean isAlive() {
        return this.bLocalAlive;
    }

    protected void logConfig(DLSScannerConfig sConfig, String strPrefix) {
        this.log.trace(this, strPrefix + " EnableUPCEAN: ................ " + sConfig.getEnableUPCEAN());
        this.log.trace(this, strPrefix + " EnableUPCD1toD5: ............. " + sConfig.getEnableUPCD1D5());
        this.log.trace(this, strPrefix + " EnableCode39: ................ " + sConfig.getEnableCode39());
        this.log.trace(this, strPrefix + " EnableInterleaved: ........... " + sConfig.getEnableInterleaved());
        this.log.trace(this, strPrefix + " EnableCodabar: ............... " + sConfig.getEnableCodabar());
        this.log.trace(this, strPrefix + " EnableCode93: ................ " + sConfig.getEnableCode93());
        this.log.trace(this, strPrefix + " EnableCode128: ............... " + sConfig.getEnableCode128());
        this.log.trace(this, strPrefix + " EnableUCCEAN128: ............. " + sConfig.getEnableUCCEAN128());
        this.log.trace(this, strPrefix + " Enable2DigitSups: ............ " + sConfig.getEnable2DigitSups());
        this.log.trace(this, strPrefix + " Enable5DigitSups: ............ " + sConfig.getEnable5DigitSups());
        this.log.trace(this, strPrefix + " EnableCode128Sups: ........... " + sConfig.getEnableCode128Sups());
        this.log.trace(this, strPrefix + " EnableUPCACheckDigit: ........ " + sConfig.getEnableUPCACheckDigit());
        this.log.trace(this, strPrefix + " EnableUPCECheckDigit: ........ " + sConfig.getEnableUPCECheckDigit());
        this.log.trace(this, strPrefix + " EnableCode39CheckDigit: ...... " + sConfig.getEnableCode39CheckDigit());
        this.log.trace(this, strPrefix + " EnableItfCheckDigit: ......... " + sConfig.getEnableITFCheckDigit());
        this.log.trace(this, strPrefix + " EnableEANJAN2LabelDecode: .... " + sConfig.getEnableEANJAN2LabelDecode());
        this.log.trace(this, strPrefix + " EnableUPCAtoEAN13Expansion: .. " + sConfig.getEnableUPCAtoEAN13Expansion());
        this.log.trace(this, strPrefix + " EnableUPCEtoEAN13Expansion: .. " + sConfig.getEnableUPCEtoEAN13Expansion());
        this.log.trace(this, strPrefix + " EnableUPCEtoUPCAExpansion: ... " + sConfig.getEnableUPCEtoUPCAExpansion());
        this.log.trace(this, strPrefix + " Enable4DigitPriceCheckDigit: . " + sConfig.getEnable4DigitPriceCheckDigit());
        this.log.trace(this, strPrefix + " Enable5DigitPriceCheckDigit: . " + sConfig.getEnable5DigitPriceCheckDigit());
        this.log.trace(this, strPrefix + " EnableGoodReadBeep: .......... " + sConfig.getEnableGoodReadBeep());
        this.log.trace(this, strPrefix + " BeepVolume: .................. " + sConfig.getBeepVolume());
        this.log.trace(this, strPrefix + " BeepFrequency: ............... " + sConfig.getBeepFrequency());
        this.log.trace(this, strPrefix + " BeepDuration: ................ " + sConfig.getBeepDuration());
        this.log.trace(this, strPrefix + " MotorTimeout: ................ " + sConfig.getMotorTimeout());
        this.log.trace(this, strPrefix + " LaserTimeout: ................ " + sConfig.getLaserTimeout());
        this.log.trace(this, strPrefix + " DoubleReadTimeout: ........... " + sConfig.getDoubleReadTimeout());
        this.log.trace(this, strPrefix + " StoreLabelSecurityLevel: ..... " + sConfig.getStoreLabelSecurityLevel());
        this.log.trace(this, strPrefix + " ITFLength1: .................. " + sConfig.getItfLength1());
        this.log.trace(this, strPrefix + " ITFLength2: .................. " + sConfig.getItfLength2());
        this.log.trace(this, strPrefix + " Two Itfs specified: .......... " + sConfig.getTwoItfs());
        this.log.trace(this, strPrefix + " ITFisRange: .................. " + sConfig.getItfRange());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfiguration() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.log.in(this, "updateConfiguration");
        this.logConfig(this.scannerConfig, " #---#");
        byte cfg0 = 0;
        byte cfg1 = 0;
        byte cfg2 = 0;
        byte cfg3 = 0;
        int cfg4 = 0;
        int cfg5 = 0;
        int cfg6 = 0;
        int cfg7 = 0;
        int cfg8 = 0;
        if (this.scannerConfig.getEnableUPCEAN()) {
            cfg0 = (byte)(cfg0 | 1);
        }
        if (this.scannerConfig.getEnableUPCD1D5()) {
            cfg0 = (byte)(cfg0 | 2);
        }
        if (this.scannerConfig.getEnableCode39()) {
            cfg0 = (byte)(cfg0 | 4);
        }
        if (this.scannerConfig.getEnableInterleaved()) {
            cfg0 = (byte)(cfg0 | 8);
        }
        if (this.scannerConfig.getEnableCodabar()) {
            cfg0 = (byte)(cfg0 | 0x10);
        }
        if (this.scannerConfig.getEnableCode93()) {
            cfg0 = (byte)(cfg0 | 0x20);
        }
        if (this.scannerConfig.getEnableCode128()) {
            cfg0 = (byte)(cfg0 | 0x40);
        }
        if (this.scannerConfig.getEnableUCCEAN128()) {
            cfg0 = (byte)(cfg0 | 0x80);
        }
        if (this.scannerConfig.getEnable2DigitSups()) {
            cfg1 = (byte)(cfg1 | 1);
        }
        if (this.scannerConfig.getEnable5DigitSups()) {
            cfg1 = (byte)(cfg1 | 2);
        }
        if (this.scannerConfig.getEnableCode128Sups()) {
            cfg1 = (byte)(cfg1 | 4);
        }
        if (this.scannerConfig.getEnableUPCACheckDigit()) {
            cfg1 = (byte)(cfg1 | 8);
        }
        if (this.scannerConfig.getEnableUPCECheckDigit()) {
            cfg1 = (byte)(cfg1 | 0x10);
        }
        if (this.scannerConfig.getEnableCode39CheckDigit()) {
            cfg1 = (byte)(cfg1 | 0x20);
        }
        if (this.scannerConfig.getEnableITFCheckDigit()) {
            cfg1 = (byte)(cfg1 | 0x40);
        }
        if (this.scannerConfig.getEnableEANJAN2LabelDecode()) {
            cfg2 = (byte)(cfg2 | 1);
        }
        if (this.scannerConfig.getEnableUPCAtoEAN13Expansion()) {
            cfg2 = (byte)(cfg2 | 2);
        }
        if (this.scannerConfig.getEnableUPCEtoEAN13Expansion()) {
            cfg2 = (byte)(cfg2 | 4);
        }
        if (this.scannerConfig.getEnableUPCEtoUPCAExpansion()) {
            cfg2 = (byte)(cfg2 | 8);
        }
        if (this.scannerConfig.getEnable4DigitPriceCheckDigit()) {
            cfg2 = (byte)(cfg2 | 0x10);
        }
        if (this.scannerConfig.getEnable5DigitPriceCheckDigit()) {
            cfg2 = (byte)(cfg2 | 0x20);
        }
        if (this.scannerConfig.getEnableGoodReadBeep()) {
            cfg3 = (byte)(cfg3 | 1);
        }
        cfg3 = (byte)(cfg3 | this.scannerConfig.getBeepVolume() << 1);
        cfg3 = (byte)(cfg3 | this.scannerConfig.getBeepFrequency() << 3);
        cfg3 = (byte)(cfg3 | this.scannerConfig.getBeepDuration() << 5);
        cfg4 = (byte)(cfg4 | this.scannerConfig.getMotorTimeout());
        cfg4 = (byte)(cfg4 | this.scannerConfig.getLaserTimeout() << 3);
        cfg4 = (byte)(cfg4 | this.scannerConfig.getDoubleReadTimeout() << 5);
        cfg5 = (byte)(cfg5 | this.scannerConfig.getStoreLabelSecurityLevel());
        cfg6 = (byte)(cfg6 | this.scannerConfig.getItfLength1());
        if (this.scannerConfig.getTwoItfs()) {
            cfg6 = (byte)(cfg6 | 0x40);
        }
        if (this.scannerConfig.getItfRange()) {
            cfg6 = (byte)(cfg6 | 0x80);
        }
        cfg7 = (byte)(cfg7 | this.scannerConfig.getItfLength2());
        cfg8 = (byte)(cfg8 | this.scannerConfig.getLEDGoodReadDuration());
        if (this.scannerConfig.getEnableBarCodeProgramming()) {
            cfg8 = (byte)(cfg8 | 4);
        }
        if (this.scannerConfig.getEnableLaserOnOffSwitch()) {
            cfg8 = (byte)(cfg8 | 8);
        }
        if (this.scannerConfig.getEnableVolumeSwitch()) {
            cfg8 = (byte)(cfg8 | 0x10);
        }
        this.configCmd[2] = cfg0;
        this.configCmd[3] = cfg1;
        this.configCmd[4] = cfg2;
        this.configCmd[5] = cfg3;
        this.configCmd[6] = cfg4;
        this.configCmd[7] = cfg5;
        this.configCmd[8] = cfg6;
        this.configCmd[9] = cfg7;
        this.configCmd[10] = cfg8;
        Object object = this.statusResp;
        synchronized (object) {
            this.statusBuf = null;
            this.port.sendData(this.configCmd, this.configCmd.length);
            try {
                this.statusResp.wait(2000L);
                if (this.statusBuf != null) {
                    if ((this.statusBuf[3] & 1) == 1) {
                        this.log.log(this, "Configuration Successful");
                    } else {
                        this.log.log(this, "Configuration Failed.");
                    }
                }
            }
            catch (InterruptedException e) {
                this.log.error(this, e.getMessage());
            }
        }
        this.log.out(this, "updateConfiguration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLSScannerConfig reportConfiguration() throws DLSException {
        this.log.in(this, "reportConfiguration");
        DLSScannerConfig sConfig = new DLSScannerConfig();
        if (this.log.getFWBusy()) {
            return sConfig;
        }
        Object object = this.reportResp;
        synchronized (object) {
            this.reportBuf = null;
            this.port.sendData(reportConfigCmd, reportConfigCmd.length);
            try {
                this.reportResp.wait(this.nTimeout);
                if (this.reportBuf != null) {
                    byte cfg0 = 0;
                    byte cfg1 = 0;
                    byte cfg2 = 0;
                    byte cfg3 = 0;
                    byte cfg4 = 0;
                    byte cfg5 = 0;
                    byte cfg6 = 0;
                    byte cfg7 = 0;
                    byte cfg8 = 0;
                    cfg0 = this.reportBuf[4];
                    cfg1 = this.reportBuf[5];
                    cfg2 = this.reportBuf[6];
                    cfg3 = this.reportBuf[7];
                    cfg4 = this.reportBuf[8];
                    cfg5 = this.reportBuf[9];
                    cfg6 = this.reportBuf[10];
                    cfg7 = this.reportBuf[11];
                    cfg8 = this.reportBuf[12];
                    sConfig.setEnableUPCEAN((cfg0 & 1) == 1);
                    sConfig.setEnableUPCD1D5((cfg0 & 2) == 2);
                    sConfig.setEnableCode39((cfg0 & 4) == 4);
                    sConfig.setEnableInterleaved((cfg0 & 8) == 8);
                    sConfig.setEnableCodabar((cfg0 & 0x10) == 16);
                    sConfig.setEnableCode93((cfg0 & 0x20) == 32);
                    sConfig.setEnableCode128((cfg0 & 0x40) == 64);
                    sConfig.setEnableUCCEAN128((cfg0 & 0x80) == 128);
                    sConfig.setEnable2DigitSups((cfg1 & 1) == 1);
                    sConfig.setEnable5DigitSups((cfg1 & 2) == 2);
                    sConfig.setEnableCode128Sups((cfg1 & 4) == 4);
                    sConfig.setEnableUPCACheckDigit((cfg1 & 8) == 8);
                    sConfig.setEnableUPCECheckDigit((cfg1 & 0x10) == 16);
                    sConfig.setEnableCode39CheckDigit((cfg1 & 0x20) == 32);
                    sConfig.setEnableITFCheckDigit((cfg1 & 0x40) == 64);
                    sConfig.setEnableEANJAN2LabelDecode((cfg2 & 1) == 1);
                    sConfig.setEnableUPCAtoEAN13Expansion((cfg2 & 2) == 2);
                    sConfig.setEnableUPCEtoEAN13Expansion((cfg2 & 4) == 4);
                    sConfig.setEnableUPCEtoUPCAExpansion((cfg2 & 8) == 8);
                    sConfig.setEnable4DigitPriceCheckDigit((cfg2 & 0x10) == 16);
                    sConfig.setEnable5DigitPriceCheckDigit((cfg2 & 0x20) == 32);
                    sConfig.setEnableGoodReadBeep((cfg3 & 1) == 1);
                    sConfig.setBeepVolume((cfg3 & 6) >> 1);
                    sConfig.setBeepFrequency((cfg3 & 0x18) >> 3);
                    sConfig.setBeepDuration((cfg3 & 0x60) >> 5);
                    sConfig.setMotorTimeout(cfg4 & 7);
                    sConfig.setLaserTimeout((cfg4 & 0x18) >> 3);
                    sConfig.setDoubleReadTimeout((cfg4 & 0x60) >> 5);
                    sConfig.setStoreLabelSecurityLevel(cfg5 & 3);
                    sConfig.setItfLength1(cfg6 & 0x3F);
                    sConfig.setTwoItfs((cfg6 & 0x40) == 64);
                    sConfig.setItfRange((cfg6 & 0x80) == 128);
                    sConfig.setItfLength2(cfg7 & 0x3F);
                    sConfig.setLEDGoodReadDuration(cfg8 & 3);
                    sConfig.setEnableBarCodeProgramming((cfg8 & 4) == 4);
                    sConfig.setEnableLaserOnOffSwitch((cfg8 & 8) == 8);
                    sConfig.setEnableVolumeSwitch((cfg8 & 0x10) == 16);
                    this.logConfig(sConfig, " #+++#");
                }
            }
            catch (InterruptedException e) {
                this.log.error(this, e.getMessage());
            }
        }
        this.log.out(this, "reportConfiguration");
        return sConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void directIO(int command, int[] data, Object object) throws DLSException {
        block55: {
            if (this.log.getFWBusy()) {
                return;
            }
            this.log.in(this, "directIO: " + command);
            byte[] buf = null;
            try {
                switch (command) {
                    case 1: {
                        Object object2 = this.objStatus;
                        synchronized (object2) {
                            this.reset();
                            try {
                                this.objStatus.wait(2 * this.nTimeout);
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                            buf = new byte[]{this.nStat1, this.nStat2, this.nStat3};
                            break;
                        }
                    }
                    case 2: {
                        Object object2 = this.objStatus;
                        synchronized (object2) {
                            this.enableBeep();
                            this.port.sendData(statusCmd, statusCmd.length);
                            try {
                                this.objStatus.wait(2 * this.nTimeout);
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                            buf = new byte[]{this.nStat1, this.nStat2, this.nStat3};
                            break;
                        }
                    }
                    case 3: {
                        Object object2 = this.objStatus;
                        synchronized (object2) {
                            this.disableBeep();
                            this.port.sendData(statusCmd, statusCmd.length);
                            try {
                                this.objStatus.wait(2 * this.nTimeout);
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                            buf = new byte[]{this.nStat1, this.nStat2, this.nStat3};
                            break;
                        }
                    }
                    case 4: {
                        if (data.length >= 9) {
                            this.configCmd[2] = (byte)data[0];
                            this.configCmd[3] = (byte)data[1];
                            this.configCmd[4] = (byte)data[2];
                            this.configCmd[5] = (byte)data[3];
                            this.configCmd[6] = (byte)data[4];
                            this.configCmd[7] = (byte)data[5];
                            this.configCmd[8] = (byte)data[6];
                            this.configCmd[9] = (byte)data[7];
                            this.configCmd[10] = (byte)data[8];
                            this.port.sendData(this.configCmd, this.configCmd.length);
                            this.nStat1 = 0;
                            this.bRaiseBusy = false;
                            do {
                                try {
                                    Thread.sleep(200L);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                this.reportConfiguration();
                            } while ((this.nStat1 & 0x80) != 0);
                            this.bRaiseBusy = true;
                            buf = new byte[]{this.nStat1, this.nStat2, this.nStat3};
                            break;
                        }
                        throw new DLSException(-2147483637, "Must provide 9 bytes of configuration data");
                    }
                    case 5: {
                        this.reportConfiguration();
                        if (this.reportBuf != null) {
                            buf = new byte[]{this.reportBuf[4], this.reportBuf[5], this.reportBuf[6], this.reportBuf[7], this.reportBuf[8], this.reportBuf[9], this.reportBuf[10], this.reportBuf[11], this.reportBuf[12]};
                            break;
                        }
                        this.log.trace(this, "reportBuf returned as null");
                        break;
                    }
                    case 6: {
                        Object e;
                        if (data.length >= 8) {
                            this.config2LabelCmd[2] = (byte)data[0];
                            this.config2LabelCmd[3] = (byte)data[1];
                            this.config2LabelCmd[4] = (byte)data[2];
                            this.config2LabelCmd[5] = (byte)data[3];
                            this.config2LabelCmd[6] = (byte)data[4];
                            this.config2LabelCmd[7] = (byte)data[5];
                            this.config2LabelCmd[8] = (byte)data[6];
                            this.config2LabelCmd[9] = (byte)data[7];
                            e = this.objStatus;
                            synchronized (e) {
                                this.port.sendData(this.config2LabelCmd, this.config2LabelCmd.length);
                                try {
                                    this.objStatus.wait(2 * this.nTimeout);
                                }
                                catch (InterruptedException ie) {
                                    // empty catch block
                                }
                            }
                            buf = new byte[]{this.nStat1, this.nStat2, this.nStat3};
                            break;
                        }
                        throw new DLSException(-2147483637, "Data array, invalid size");
                    }
                    case 7: {
                        Object e = this.reportResp;
                        synchronized (e) {
                            this.reportBuf = null;
                            this.port.sendData(reportConfig2LabelCmd, reportConfig2LabelCmd.length);
                            try {
                                this.reportResp.wait(this.nTimeout);
                                if (this.reportBuf == null) {
                                    throw new DLSException(-2147483640, "Unable to retrieve 2Label Config Data");
                                }
                                buf = new byte[]{this.reportBuf[4], this.reportBuf[5], this.reportBuf[6], this.reportBuf[7], this.reportBuf[8], this.reportBuf[9], this.reportBuf[10], this.reportBuf[11]};
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                            break;
                        }
                    }
                    case 8: {
                        buf = this.doInternalDirectIO((byte)1);
                        break;
                    }
                    case 9: {
                        buf = this.doInternalDirectIO((byte)2);
                        break;
                    }
                    case 10: {
                        buf = this.doInternalDirectIO((byte)3);
                        break;
                    }
                    case 11: {
                        if (this.deviceInfo.getUsage() == 18944) {
                            buf = this.doInternalDirectIO((byte)34);
                            break;
                        }
                        buf = this.doInternalDirectIO((byte)4);
                        break;
                    }
                    case 12: {
                        buf = this.doInternalDirectIO((byte)5);
                        break;
                    }
                    case 13: {
                        buf = this.doInternalDirectIO((byte)6);
                        break;
                    }
                    case 41: {
                        buf = new String("USB").getBytes();
                        break;
                    }
                    default: {
                        throw new DLSException(-2147483637, "Invalid directio command received");
                    }
                }
                if (buf == null) break block55;
                try {
                    ByteArrayOutputStream bs = (ByteArrayOutputStream)object;
                    if (bs instanceof ByteArrayOutputStream) {
                        bs.write(buf);
                    }
                }
                catch (Exception e) {
                    this.log.error(this, "Unable to return data to DIO caller - Are you passing in a ByteArrayOuputStream object?");
                    throw new DLSException(-2147483637, "Need a ByteArrayOutStream object to return data");
                }
            }
            catch (Exception e) {
                this.log.error(this, "Caught exception in DLSUSBScanner::directIO");
            }
        }
        this.log.out(this, "directIO");
    }

    public boolean hasStatisticsReporting() {
        boolean stats = this.scannerConfig.getCanAcceptStatisticsCmd();
        return stats;
    }

    public Hashtable getStatistics() throws DLSException {
        String truncated2;
        String truncated;
        this.log.in(this, "getStatistics");
        String[] strInfo = null;
        String[] strStat = null;
        Hashtable<String, String> table = new Hashtable<String, String>();
        byte[] buf = null;
        String str = "";
        int i = 0;
        String put = table.put(DLS_S_GOOD_SCAN_COUNT, "NA");
        if (this.log.getFWBusy()) {
            return table;
        }
        if (!this.scannerConfig.getCanAcceptStatisticsCmd()) {
            this.log.trace(this, "scanner does not support statistics data.");
            return table;
        }
        put = table.put(DLS_S_DEVICE_CATEGORY, "Scanner");
        put = table.put(DLS_S_INTERFACE, "USB");
        if (this.log.getFWBusy()) {
            return table;
        }
        buf = this.doInternalDirectIO((byte)1);
        String logData = "";
        for (i = 0; i < buf.length; ++i) {
            logData = logData + " 0x" + Integer.toHexString(buf[i] & 0xFF);
        }
        this.log.log(this, "# bytes received[" + buf.length + "]" + logData);
        put = table.put("RawInfo", "# bytes received[" + buf.length + "]" + logData);
        if (buf == null || buf.length == 0) {
            if (this.hasStatisticsReporting()) {
                throw new DLSException(-2147483640, "Unable to get statistics data.");
            }
            this.log.trace(this, "scanner does not support statistics data.");
            return table;
        }
        String strInfoString = new String(buf);
        strInfo = strInfoString.split("\u0003");
        block45: for (i = 0; i < strInfo.length; ++i) {
            str = strInfo[i];
            truncated = str.replaceAll("\\p{Cntrl}", "");
            truncated2 = truncated.replaceAll("Sp<", "");
            if (truncated2.length() <= 1) continue;
            switch (truncated2.charAt(0)) {
                case 'M': {
                    put = table.put(DLS_S_MODEL_NAME, truncated2.substring(1));
                    continue block45;
                }
                case 'S': {
                    put = table.put(DLS_S_SERIAL_NUMBER, truncated2.substring(1));
                    continue block45;
                }
                case 'm': {
                    put = table.put(DLS_S_SCANNER_BOARD_SERIAL, truncated2.substring(1));
                    continue block45;
                }
                case 'A': {
                    put = table.put(DLS_S_FIRMWARE_VERSION, truncated2.substring(1));
                    continue block45;
                }
                case 'R': {
                    put = table.put(DLS_S_SCANNER_REVISION, truncated2.substring(1));
                    continue block45;
                }
                case 'C': {
                    put = table.put(DLS_S_SCANNER_CONFIG_FILE_ID, truncated2.substring(1));
                    continue block45;
                }
                case 'B': {
                    put = table.put(DLS_S_SCANNER_BOOT_ROM_ID, truncated2.substring(1));
                    continue block45;
                }
                case 'H': {
                    put = table.put(DLS_HH_RADIO_VERSION, truncated2.substring(1));
                    continue block45;
                }
                case 'U': {
                    put = table.put(DLS_S_UNIVERSAL_ROM_ID, truncated2.substring(1));
                    continue block45;
                }
                case 'u': {
                    put = table.put(DLS_S_UNIVERSAL_BOOT_ROM_ID, truncated2.substring(1));
                    continue block45;
                }
                case 'W': {
                    put = table.put(DLS_S_SCALE_INFO, truncated2.substring(1));
                    continue block45;
                }
                case 'D': {
                    put = table.put(DLS_S_DISPLAY_VERSION, truncated2.substring(1));
                    continue block45;
                }
                case 'E': {
                    put = table.put(DLS_S_EAS_VERSION, truncated2.substring(1));
                    continue block45;
                }
                case 'I': {
                    put = table.put(DLS_S_SCANNER_INTERFACE, truncated2.substring(1));
                    continue block45;
                }
                case 'r': {
                    put = table.put(DLS_HH_RADIO_APP_VERSION, truncated2.substring(1));
                    continue block45;
                }
                case 'L': {
                    put = table.put(DLS_HH_RADIO_APP_VERSION, truncated2.substring(1));
                    continue block45;
                }
                case 'b': {
                    put = table.put(DLS_HH_RADIO_BOOTLOADER_VERSION, truncated2.substring(1));
                    continue block45;
                }
                case 'X': {
                    put = table.put(DLS_HH_MODEL_NAME, truncated2.substring(1));
                }
            }
        }
        this.log.log(this, "Getting healthRequestCmd");
        this.bStatMessageSent = true;
        buf = this.doInternalDirectIO((byte)2);
        if (buf == null) {
            throw new DLSException(-2147483640, "Error retrieving Health via DirectIO");
        }
        logData = "";
        for (i = 0; i < buf.length; ++i) {
            logData = logData + " 0x" + Integer.toHexString(buf[i] & 0xFF);
        }
        this.log.log(this, "# bytes received[" + buf.length + "]" + logData);
        put = table.put("RawHealth", "# bytes received[" + buf.length + "]" + logData);
        strInfoString = new String(buf);
        strStat = strInfoString.split("\u0003");
        block47: for (i = 0; i < strStat.length; ++i) {
            str = strStat[i];
            truncated = str.replaceAll("\\p{Cntrl}", "");
            truncated2 = truncated.replaceAll("Sp<", "");
            if (truncated2.length() <= 1) continue;
            switch (truncated2.charAt(0)) {
                case 'm': {
                    put = table.put(DLS_S_MOTOR_HEALTH, truncated2.substring(1));
                    continue block47;
                }
                case 'h': {
                    put = table.put(DLS_S_V_LASER_HEALTH, truncated2.substring(1));
                    continue block47;
                }
                case 'v': {
                    put = table.put(DLS_S_H_LASER_HEALTH, truncated2.substring(1));
                    continue block47;
                }
                case 's': {
                    put = table.put(DLS_S_SCALE_HEALTH, truncated2.substring(1));
                    continue block47;
                }
                case 'd': {
                    put = table.put(DLS_S_REMOTE_DISPLAY_HEALTH, truncated2.substring(1));
                    continue block47;
                }
                case 'e': {
                    put = table.put(DLS_S_EAS_HEALTH, truncated2.substring(1));
                    continue block47;
                }
                case 'c': {
                    put = table.put(DLS_S_CAMERA_HEALTH, truncated2.substring(1));
                    continue block47;
                }
                case 'r': {
                    put = table.put(DLS_HH_RADIO_HEALTH, truncated2.substring(1));
                }
            }
        }
        this.log.log(this, "Getting statisticsCmd");
        this.bStatMessageSent = true;
        buf = this.doInternalDirectIO((byte)3);
        if (buf == null) {
            throw new DLSException(-2147483640, "Error retrieving Statistics via DirectIO");
        }
        logData = "";
        for (i = 0; i < buf.length; ++i) {
            logData = logData + " 0x" + Integer.toHexString(buf[i] & 0xFF);
        }
        this.log.log(this, "# bytes received[" + buf.length + "]" + logData);
        put = table.put("RawStats", "# bytes received[" + buf.length + "]" + logData);
        strInfoString = new String(buf);
        strStat = strInfoString.split("\u0003");
        block49: for (i = 0; i < strStat.length; ++i) {
            str = strStat[i];
            truncated = str.replaceAll("\\p{Cntrl}", "");
            truncated2 = truncated.replaceAll("Sp<", "");
            if (truncated2.length() <= 1) continue;
            switch (truncated2.charAt(0)) {
                case 'P': {
                    put = table.put(DLS_S_SCANNER_TIME, truncated2.substring(1));
                    continue block49;
                }
                case 'm': {
                    put = table.put(DLS_S_HOURS_POWERED_COUNT, truncated2.substring(1));
                    continue block49;
                }
                case 'l': {
                    put = table.put(DLS_S_LASER_TIME, truncated2.substring(1));
                    continue block49;
                }
                case 'L': {
                    put = table.put(DLS_S_GOOD_SCAN_COUNT, truncated2.substring(1));
                    continue block49;
                }
                case 'z': {
                    put = table.put(DLS_S_SCALE_ZEROS, truncated2.substring(1));
                    continue block49;
                }
                case 'c': {
                    put = table.put(DLS_S_SCALE_CALS, truncated2.substring(1));
                    continue block49;
                }
                case 'C': {
                    put = table.put(DLS_S_SCALE_CAL_TIME, truncated2.substring(1));
                    continue block49;
                }
                case 'E': {
                    put = table.put(DLS_S_EAS_DEACTIVATED, truncated2.substring(1));
                    continue block49;
                }
                case 'e': {
                    put = table.put(DLS_S_EAS_MANUAL, truncated2.substring(1));
                    continue block49;
                }
                case 'B': {
                    put = table.put(DLS_HH_BATTERY_CHG_CYCLES, truncated2.substring(1));
                    continue block49;
                }
                case 'T': {
                    put = table.put(DLS_HH_TRIGGER_PULLS, truncated2.substring(1));
                    continue block49;
                }
                case 'K': {
                    put = table.put(DLS_HH_KEY_PRESSES, truncated2.substring(1));
                }
            }
        }
        if (!table.contains(DLS_S_INTERFACE)) {
            put = table.put(DLS_S_INTERFACE, "USB");
        }
        put = table.put(DLS_S_MANUFACTURE_NAME, "DLA");
        put = table.put(DLS_S_DEVICE_CATEGORY, "Scanner");
        this.bStatMessageSent = false;
        this.hTable = table;
        this.log.out(this, "getStatistics");
        return table;
    }

    public Hashtable returnStatistics() throws DLSException {
        return this.hTable;
    }

    public void onDeviceAdded() {
    }

    public void onDeviceReattached() {
        if (this.bReattachPending) {
            this.bReattachPending = true;
            this.log.trace(this, "Device reattached");
            this.port.openPort();
            try {
                if (this.bEnabled) {
                    this.enable();
                }
                this.port.sendData(statusCmd, statusCmd.length);
            }
            catch (DLSException dLSException) {
                // empty catch block
            }
        }
    }

    public void onDeviceRemoved() {
        if (!this.bReattachPending) {
            this.port.closePort();
            this.fireDeviceErrorEvent(-116);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataReceived(byte[] inBuf, int inLen) {
        super.onDataReceived(inBuf, inLen);
        int nResp = 0;
        boolean b2DLabel = false;
        Object object = this.objStatus;
        synchronized (object) {
            nResp |= inBuf[1];
            nResp |= inBuf[2] << 8;
            nResp |= inBuf[3] << 16;
            this.nStat1 = inBuf[1];
            this.nStat2 = inBuf[2];
            this.nStat3 = inBuf[3];
            this.objStatus.notifyAll();
        }
        int nType = 0;
        String logData = "";
        for (int i = 0; i < inBuf.length; ++i) {
            logData = logData + " 0x" + Integer.toHexString(inBuf[i] & 0xFF);
        }
        this.log.log(this, "# raw bytes received[" + inBuf.length + "]" + logData);
        if ((nResp & 0x100) == 256) {
            if (!this.bLocalAlive) {
                this.fireDeviceStatusEvent(-200);
                this.bLocalAlive = true;
            }
        } else if (this.bLocalAlive) {
            this.fireDeviceStatusEvent(-201);
            this.bLocalAlive = false;
        }
        if ((nResp & 0x200) == 512) {
            if (!this.bEnabled) {
                this.fireDeviceStatusEvent(-202);
                this.bEnabled = true;
            }
        } else if (this.bEnabled) {
            this.fireDeviceStatusEvent(-203);
            this.bEnabled = false;
        }
        if ((nResp & 1) == 1) {
            this.fireDeviceErrorEvent(-111);
        } else if ((nResp & 0x20) == 32) {
            this.fireDeviceErrorEvent(-105);
        } else if ((nResp & 0x80) == 128) {
            if (this.bRaiseBusy) {
                this.fireDeviceErrorEvent(-112);
            }
        } else if ((nResp & 0x400) == 1024) {
            this.fireDeviceErrorEvent(-113);
        } else if ((nResp & 0x8000) == 32768) {
            this.fireDeviceErrorEvent(-100);
        } else if ((nResp & 0x100000) == 0x100000) {
            this.fireDeviceErrorEvent(-114);
        } else if ((nResp & 0x200000) == 0x200000) {
            this.fireDeviceErrorEvent(-115);
        } else if ((nResp & 2) == 2) {
            Object i = this.reportResp;
            synchronized (i) {
                this.reportBuf = inBuf;
                this.reportResp.notifyAll();
            }
        } else if ((nResp & 4) == 4) {
            Object i = this.reportResp;
            synchronized (i) {
                this.reportBuf = inBuf;
                this.reportResp.notifyAll();
            }
        } else if ((nResp & 0x40) == 64) {
            Object i = this.dioResp;
            synchronized (i) {
                if (this.bInternalDIO) {
                    this.bInternalDIO = false;
                    this.dioBuf = inBuf;
                    this.dioResp.notifyAll();
                }
            }
        } else if ((nResp & 0x80000) != 524288 && (nResp & 0x40000) != 262144) {
            if (inBuf[0] == 4) {
                Object i = this.statusResp;
                synchronized (i) {
                    this.statusBuf = inBuf;
                    this.statusResp.notifyAll();
                }
            } else {
                int bufLen = inBuf[0];
                byte moreDataByte = inBuf[bufLen - 3];
                block10 : switch (inBuf[bufLen - 1]) {
                    case 22: {
                        --bufLen;
                        nType = 104;
                        break;
                    }
                    case 12: {
                        --bufLen;
                        nType = 103;
                        break;
                    }
                    case 13: {
                        --bufLen;
                        nType = 101;
                        break;
                    }
                    case 10: {
                        --bufLen;
                        nType = 102;
                        break;
                    }
                    case 17: {
                        bufLen -= 2;
                        nType = 113;
                        break;
                    }
                    case 18: {
                        bufLen -= 2;
                        nType = 114;
                        break;
                    }
                    case 20: {
                        bufLen -= 2;
                        nType = 115;
                        break;
                    }
                    case 23: {
                        bufLen -= 2;
                        nType = 116;
                        break;
                    }
                    case 29: {
                        bufLen -= 2;
                        nType = 117;
                        break;
                    }
                    case 11: {
                        byte nextByte = inBuf[bufLen - 2];
                        switch (nextByte) {
                            case 22: {
                                bufLen -= 3;
                                nType = 111;
                                break block10;
                            }
                            case 17: {
                                bufLen -= 3;
                                nType = 111;
                                break block10;
                            }
                            case 18: {
                                bufLen -= 3;
                                nType = 112;
                                break block10;
                            }
                            case 20: {
                                bufLen -= 3;
                                nType = 112;
                                break block10;
                            }
                            case 23: {
                                bufLen -= 3;
                                nType = 118;
                                break block10;
                            }
                            case 29: {
                                bufLen -= 3;
                                nType = 118;
                                break block10;
                            }
                            case 19: {
                                bufLen -= 3;
                                nType = 119;
                                break block10;
                            }
                            case 21: {
                                bufLen -= 3;
                                nType = 119;
                                break block10;
                            }
                            case 12: {
                                bufLen -= 3;
                                nType = 105;
                                break block10;
                            }
                            case 13: {
                                bufLen -= 3;
                                nType = 106;
                                break block10;
                            }
                            case 10: {
                                bufLen -= 3;
                                nType = 108;
                                break block10;
                            }
                            case 24: {
                                bufLen -= 3;
                                nType = 110;
                                break block10;
                            }
                            case 14: {
                                bufLen -= 3;
                                nType = 107;
                                break block10;
                            }
                            case 25: {
                                bufLen -= 3;
                                nType = 109;
                                break block10;
                            }
                            case 37: {
                                bufLen -= 3;
                                nType = 120;
                                break block10;
                            }
                            case 32: {
                                bufLen -= 3;
                                nType = 111;
                                break block10;
                            }
                            case 33: {
                                bufLen -= 3;
                                nType = 112;
                                break block10;
                            }
                            case 34: {
                                bufLen -= 3;
                                nType = 118;
                                break block10;
                            }
                            case 35: {
                                bufLen -= 3;
                                nType = 119;
                                break block10;
                            }
                            case 42: {
                                bufLen -= 3;
                                nType = 131;
                                b2DLabel = true;
                                break block10;
                            }
                            case 43: {
                                bufLen -= 3;
                                nType = 132;
                                b2DLabel = true;
                                break block10;
                            }
                            case 46: {
                                bufLen -= 3;
                                nType = 201;
                                b2DLabel = true;
                                break block10;
                            }
                            case 47: {
                                bufLen -= 3;
                                nType = 202;
                                b2DLabel = true;
                                break block10;
                            }
                            case 50: {
                                bufLen -= 3;
                                nType = 203;
                                b2DLabel = true;
                                break block10;
                            }
                            case 51: {
                                bufLen -= 3;
                                nType = 204;
                                b2DLabel = true;
                                break block10;
                            }
                            case 52: {
                                bufLen -= 3;
                                nType = 206;
                                b2DLabel = true;
                                break block10;
                            }
                        }
                        bufLen -= 3;
                        nType = 0;
                        b2DLabel = true;
                    }
                }
                byte[] labelData = null;
                labelData = new byte[bufLen - 4];
                for (int i = 4; i < bufLen; ++i) {
                    labelData[i - 4] = inBuf[i];
                }
                if (this.deviceInfo.getUsage() == 18944) {
                    switch (nType) {
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 111: 
                        case 112: 
                        case 118: 
                        case 119: {
                            DLSProperties options = DLSProperties.getInstance();
                            this.bConvertBCDtoASCII = options.get("com.dls.jpos.service.ScannerService.convertBCDtoASCII", true);
                            if (!this.bConvertBCDtoASCII) break;
                            for (int i = 0; i < labelData.length; ++i) {
                                if (labelData[i] < 0 || labelData[i] > 9) continue;
                                labelData[i] = (byte)(labelData[i] + 48);
                            }
                            break;
                        }
                    }
                }
                if (moreDataByte == 16) {
                    this.concatUSBMessages(labelData, false);
                    return;
                }
                this.concatUSBMessages(labelData, true);
                Iterator it = this.msgList.iterator();
                while (it.hasNext()) {
                    byte[] tmpBuf = (byte[])it.next();
                    if (tmpBuf.length <= 2) continue;
                    DLSProperties options = DLSProperties.getInstance();
                    this.bSendCookedData = options.get("com.dls.jpos.service.ScannerService.sendCookedData", false);
                    if (this.bSendCookedData) {
                        tmpBuf = labelData;
                    }
                    this.fireLabelReceivedEvent(tmpBuf, tmpBuf, nType);
                    logData = "";
                    for (int i = 0; i < tmpBuf.length; ++i) {
                        logData = logData + " 0x" + Integer.toHexString(tmpBuf[i] & 0xFF);
                    }
                    this.log.log(this, "# bytes received[" + tmpBuf.length + "]" + logData);
                }
                this.msgList.clear();
                return;
            }
        }
    }
}

