/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSScannerConfig;
import com.dls.jpos.interpretation.DLSScanner;
import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import java.util.Iterator;

public class DLSSCSerialScanner
extends DLSScanner
implements DLSJposConst {
    protected static int DST_POS = 1;
    protected static int CMD_POS = 2;
    protected static int RSP_POS = 2;
    protected static final String enableCmd = "01";
    protected static final String disableCmd = "02";
    protected static final String hardResetCmd = "00";
    protected static final String statusCmd = "03";
    protected static final String switchReadCmd = "04";
    protected static final String disableLED = "06";
    protected static final String spDisplayData = "21";
    protected static final String spDisplayStatus = "23";
    protected static final String spScannerNotOnFile = "33F";
    protected static final String spSoftResetCmd = "320";
    protected static final String spSetDefaultsCmd = "32C";
    protected static final String spEnableToneCmd = "32F";
    protected static final String spBeepGoodToneCmd = "334";
    protected static final String spShutDownCmd = "335";
    protected static final String spStatusCmd = "336";
    protected static final String spHealthCmd = "3p=";
    protected static final String spIdentificationCmd = "3p<";
    protected static final String spStatisticsCmd = "3p>";
    protected static final String spFirmwareUpdateCmd = "3p0";
    protected static final String spSaveAndResetCmd = "337";
    protected static final String spDisableToneCmd = "339";
    protected static final String spEnterToadModeCmd = "33A";
    protected static final String spReadPacesetterCmd = "3=2";
    protected static final String spResetPacesetterCmd = "3=<";
    protected static final String spEnablePacesetterPlusTrailerCmd = "3=>>";
    protected static final String spDisablePacesetterPlusTrailerCmd = "3=??";
    protected Object objSpecial = new Object();
    protected byte[] specialBuf = null;
    protected Hashtable hTable;

    public void open(String strLogicalName) throws DLSException {
        super.open(strLogicalName);
        byte b = this.deviceInfo.getRxPrefix();
        if (b == 0) {
            CMD_POS = 1;
            DST_POS = 0;
            RSP_POS = 1;
        } else {
            CMD_POS = 2;
            DST_POS = 1;
            RSP_POS = 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sendSpecialMsg(String strMsg) {
        this.log.in(this, "sendSpecialMsg: " + strMsg);
        int iSent = 0;
        Object object = this.objSpecial;
        synchronized (object) {
            this.specialBuf = null;
            iSent = this.sendMsg(strMsg);
            try {
                this.objSpecial.wait(this.nTimeout);
            }
            catch (InterruptedException ie) {
                this.log.trace(this, "Interrupt exception " + ie);
            }
        }
        this.log.out(this, "sendSpecialMsg: " + iSent);
        return this.specialBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendRecord(String sRecord) {
        this.log.in(this, "sendRecord");
        Object object = this.objSpecial;
        synchronized (object) {
            this.nResponse = 255;
            this.specialBuf = null;
            this.sendMsg(spFirmwareUpdateCmd + sRecord);
            try {
                this.objSpecial.wait(this.nRecordTimeout);
                if (this.specialBuf != null) {
                    this.nResponse = this.specialBuf[RSP_POS] == 48 ? 6 : (this.specialBuf[RSP_POS] == 49 ? 21 : (this.specialBuf[RSP_POS] == 50 ? 7 : (this.specialBuf[RSP_POS] == 51 ? 7 : 239)));
                }
            }
            catch (InterruptedException ie) {
                this.nResponse = 255;
            }
        }
        this.log.out(this, "sendRecord");
        return this.nResponse;
    }

    public void enable() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.log.in(this, "enable");
        if (!this.isAlive()) {
            this.log.error(this, "No RS232 Standard Scanner device attached to port.");
            throw new DLSException(-2147483638, "No RS232 Standard Scanner device attached to port.");
        }
        this.sendMsg(enableCmd);
        this.log.out(this, "enable");
    }

    public void disable() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.log.in(this, "disable");
        this.sendMsg(disableLED);
        this.log.out(this, "disable");
    }

    public void reset() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.log.in(this, "reset");
        this.sendMsg(hardResetCmd);
        this.log.out(this, "reset");
    }

    public void enableBeep() {
        if (this.log.getFWBusy()) {
            return;
        }
        this.log.in(this, "enableBeep");
        this.sendMsg(spEnableToneCmd);
        this.log.out(this, "enableBeep");
    }

    public void disableBeep() {
        if (this.log.getFWBusy()) {
            return;
        }
        this.log.in(this, "disableBeep");
        this.sendMsg(spDisableToneCmd);
        this.log.out(this, "disableBeep");
    }

    public int sendJoin() {
        return 0;
    }

    public int sendReset() {
        return 0;
    }

    public void doSelfTest() {
        if (this.log.getFWBusy()) {
            return;
        }
        this.log.in(this, "doSelfTest");
        this.bAlive = true;
        byte[] buf = this.sendSpecialMsg(spStatusCmd);
        if (buf == null) {
            this.bAlive = false;
            this.fireDeviceErrorEvent(-2147483638);
        }
        this.log.out(this, "doSelfTest");
    }

    public boolean doHealthCheck() throws DLSException {
        if (this.log.getFWBusy()) {
            return true;
        }
        this.log.in(this, "doHealthCheck");
        boolean bRc = true;
        byte[] buf = this.sendSpecialMsg(spHealthCmd);
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] == 1) {
                buf[i] = 2;
            }
            if (buf[i] != 4) continue;
            buf[i] = 3;
        }
        try {
            this.logHealthCheck(buf);
        }
        catch (DLSException psce) {
            this.log.error(this, "doHealthCheck: " + psce.getMessage());
            throw psce;
        }
        this.log.out(this, "doHealthCheck");
        return bRc;
    }

    public boolean isAlive() {
        if (this.log.getFWBusy()) {
            return this.bAlive;
        }
        this.log.in(this, "isAlive");
        this.doSelfTest();
        this.log.out(this, "isAlive");
        return this.bAlive;
    }

    public void setFirmwareBaudRate() {
        this.log.in(this, "setFirmwareBaudRate");
        int nOrigBaud = this.deviceInfo.getBaud();
        int nBaud = this.scannerConfig.getUpdateBaudRate();
        if (nBaud > nOrigBaud) {
            this.port.changeBaudRate(nBaud);
            if (!this.isAlive()) {
                this.port.changeBaudRate(nOrigBaud);
            }
        }
        this.log.out(this, "setFirmwareBaudRate");
    }

    public void restoreBaudRate() {
        this.log.in(this, "restoreBaudRate");
        int nOrigBaud = this.deviceInfo.getBaud();
        int nBaud = this.scannerConfig.getUpdateBaudRate();
        if (nBaud != nOrigBaud) {
            this.port.changeBaudRate(nOrigBaud);
        }
        this.log.out(this, "restoreBaudRate");
    }

    public void updateConfiguration() {
        this.log.in(this, "updateConfiguration");
        this.log.out(this, "updateConfiguration");
    }

    public DLSScannerConfig reportConfiguration() {
        this.log.in(this, "reportConfiguration");
        this.log.out(this, "reportConfiguration");
        return this.scannerConfig;
    }

    public void directIO(int command, int[] data, Object object) throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.log.in(this, "directIO");
        byte[] buf = null;
        String[] strInfo = null;
        String str = null;
        String strResult = "Invalid Command";
        block1 : switch (command) {
            case 1: 
            case 502: {
                this.sendMsg(hardResetCmd);
                strResult = "Scanner reset";
                break;
            }
            case 2: 
            case 503: {
                buf = this.sendSpecialMsg(statusCmd);
                strResult = "Scanner status: ";
                if (buf != null && buf.length >= 4) {
                    if (buf[RSP_POS] == 48 && buf[RSP_POS + 1] == 49 && buf[RSP_POS + 3] == 48) {
                        switch (buf[RSP_POS + 2]) {
                            case 48: {
                                strResult = strResult + "Disabled";
                                break block1;
                            }
                            case 49: {
                                strResult = strResult + "Enabled";
                                break block1;
                            }
                        }
                        strResult = strResult + "unknown";
                        break;
                    }
                    strResult = strResult + "unknown";
                    break;
                }
                strResult = strResult + "Failed";
                break;
            }
            case 3: {
                this.sendMsg(switchReadCmd);
                strResult = "Scanner switch read";
                break;
            }
            case 4: 
            case 508: {
                this.sendMsg(spScannerNotOnFile);
                strResult = "Scanner Not on File";
                break;
            }
            case 5: {
                this.sendMsg(disableLED);
                strResult = "Disable with Red Light flashing";
                break;
            }
            case 8: {
                buf = this.sendSpecialMsg(spDisplayData + data);
                strResult = "Display data: ";
                if (buf != null) {
                    strResult = strResult + "Accepted";
                    break;
                }
                strResult = strResult + "Failed";
                break;
            }
            case 9: {
                buf = this.sendSpecialMsg(spDisplayStatus);
                strResult = "Display status: ";
                if (buf != null) {
                    switch (buf[RSP_POS]) {
                        case 48: {
                            strResult = strResult + "Price and Weight";
                            break block1;
                        }
                        case 49: {
                            strResult = strResult + "Weight Only";
                            break block1;
                        }
                        case 50: {
                            strResult = strResult + "Alpha Numeric (unsupported)";
                            break block1;
                        }
                    }
                    strResult = strResult + "unknown";
                    break;
                }
                strResult = strResult + "Failed";
                break;
            }
            case 10: {
                this.sendMsg(spEnableToneCmd);
                strResult = "Enable tone";
                break;
            }
            case 11: 
            case 501: {
                this.sendMsg(spBeepGoodToneCmd);
                strResult = "Scanner beep";
                break;
            }
            case 12: {
                this.sendMsg(spShutDownCmd);
                strResult = "Soft Power down";
                break;
            }
            case 13: {
                this.sendMsg(spDisableToneCmd);
                strResult = "Scanner disable tone";
                break;
            }
            case 14: {
                this.sendMsg(spEnterToadModeCmd);
                strResult = "Enter Tode";
                break;
            }
            case 15: 
            case 506: {
                this.sendMsg(spReadPacesetterCmd + data);
                strResult = "Read Pacesetter";
                break;
            }
            case 16: {
                this.sendMsg(spResetPacesetterCmd);
                strResult = "Reset Pacesetter";
                break;
            }
            case 17: {
                this.sendMsg(spEnablePacesetterPlusTrailerCmd);
                strResult = "Enable Pacesetter";
                break;
            }
            case 18: {
                this.sendMsg(spDisablePacesetterPlusTrailerCmd);
                strResult = "Disable Pacesetter";
                break;
            }
            case 19: {
                this.sendMsg(spSoftResetCmd);
                strResult = "Scanner Soft Reset";
                break;
            }
            case 20: {
                buf = this.sendSpecialMsg(spIdentificationCmd);
                strResult = "";
                if (buf == null) {
                    strResult = "Identification Failed";
                    break;
                }
                String strInfoString = new String(buf);
                strInfo = strInfoString.split("\u0003");
                for (int i = 0; i < strInfo.length; ++i) {
                    str = strInfo[i];
                    String truncated = str.replaceAll("\\p{Cntrl}", "");
                    String truncated2 = truncated.replaceAll("Sp<", "");
                    strResult = strResult + truncated2;
                    strResult = strResult + " ";
                }
                str = strResult;
                break;
            }
            case 21: {
                buf = this.sendSpecialMsg(spHealthCmd);
                strResult = "";
                if (buf == null) {
                    strResult = "Health Failed";
                    break;
                }
                String strInfoString = new String(buf);
                strInfo = strInfoString.split("\u0003");
                for (int i = 0; i < strInfo.length; ++i) {
                    str = strInfo[i];
                    String truncated = str.replaceAll("\\p{Cntrl}", "");
                    String truncated2 = truncated.replaceAll("Sp<", "");
                    strResult = strResult + truncated2;
                    strResult = strResult + " ";
                }
                str = strResult;
                break;
            }
            case 22: {
                buf = this.sendSpecialMsg(spStatisticsCmd);
                strResult = "";
                if (buf == null) {
                    strResult = "Statistics Failed";
                    break;
                }
                String strInfoString = new String(buf);
                strInfo = strInfoString.split("\u0003");
                for (int i = 0; i < strInfo.length; ++i) {
                    str = strInfo[i];
                    String truncated = str.replaceAll("\\p{Cntrl}", "");
                    String truncated2 = truncated.replaceAll("Sp<", "");
                    strResult = strResult + truncated2;
                    strResult = strResult + " ";
                }
                str = strResult;
            }
        }
        try {
            ByteArrayOutputStream bs = (ByteArrayOutputStream)object;
            if (bs instanceof ByteArrayOutputStream) {
                bs.write(strResult.getBytes());
            }
        }
        catch (Exception e) {
            this.log.error(this, "Unable to return data to DIO caller - Are you passing in a ByteArrayOuputStream object?");
        }
        this.log.out(this, "directIO");
    }

    protected int extractBarcodeType(byte b1, byte b2) {
        int nType = super.extractBarcodeType(b1, b2);
        if (nType == 0 && b1 == 66) {
            switch (b2) {
                case 49: {
                    nType = 108;
                    break;
                }
                case 50: {
                    nType = 106;
                    break;
                }
                case 51: {
                    nType = 110;
                }
            }
        }
        return nType;
    }

    public boolean hasStatisticsReporting() {
        return this.scannerConfig.getCanAcceptStatisticsCmd();
    }

    public Hashtable getStatistics() throws DLSException {
        this.log.in(this, "getStatistics");
        Hashtable<String, String> table = new Hashtable<String, String>();
        String put = table.put(DLS_S_GOOD_SCAN_COUNT, "NA");
        if (this.log.getFWBusy()) {
            return table;
        }
        if (!this.scannerConfig.getCanAcceptStatisticsCmd()) {
            return table;
        }
        String[] strInfo = null;
        String str = null;
        int i = 0;
        if (this.hasStatisticsReporting()) {
            String truncated2;
            String truncated;
            String strInfoString;
            byte[] buf = this.sendSpecialMsg(spIdentificationCmd);
            String logData = "";
            for (i = 0; i < buf.length; ++i) {
                logData = logData + " 0x" + Integer.toHexString(buf[i] & 0xFF);
            }
            this.log.log(this, "# bytes received[" + buf.length + "]" + logData);
            put = table.put("RawInfo", "# bytes received[" + buf.length + "]" + logData);
            if (buf != null && buf.length != 0) {
                strInfoString = new String(buf);
                strInfo = strInfoString.split("\u0004");
                block44: for (i = 0; i < strInfo.length; ++i) {
                    str = strInfo[i];
                    truncated = str.replaceAll("\\p{Cntrl}", "");
                    truncated2 = truncated.replaceAll("Sp<", "");
                    if (truncated2.equals("")) continue;
                    switch (truncated2.charAt(0)) {
                        case 'M': {
                            put = table.put(DLS_S_MODEL_NAME, truncated2.substring(1));
                            continue block44;
                        }
                        case 'S': {
                            put = table.put(DLS_S_SERIAL_NUMBER, truncated2.substring(1));
                            continue block44;
                        }
                        case 'm': {
                            put = table.put(DLS_S_SCANNER_BOARD_SERIAL, truncated2.substring(1));
                            continue block44;
                        }
                        case 'A': {
                            put = table.put(DLS_S_FIRMWARE_VERSION, truncated2.substring(1));
                            continue block44;
                        }
                        case 'R': {
                            put = table.put(DLS_S_SCANNER_REVISION, truncated2.substring(1));
                            continue block44;
                        }
                        case 'C': {
                            put = table.put(DLS_S_SCANNER_CONFIG_FILE_ID, truncated2.substring(1));
                            continue block44;
                        }
                        case 'B': {
                            put = table.put(DLS_S_SCANNER_BOOT_ROM_ID, truncated2.substring(1));
                            continue block44;
                        }
                        case 'U': {
                            put = table.put(DLS_S_UNIVERSAL_ROM_ID, truncated2.substring(1));
                            continue block44;
                        }
                        case 'u': {
                            put = table.put(DLS_S_UNIVERSAL_BOOT_ROM_ID, truncated2.substring(1));
                            continue block44;
                        }
                        case 'W': {
                            put = table.put(DLS_S_SCALE_INFO, truncated2.substring(1));
                            continue block44;
                        }
                        case 'D': {
                            put = table.put(DLS_S_DISPLAY_VERSION, truncated2.substring(1));
                            continue block44;
                        }
                        case 'E': {
                            put = table.put(DLS_S_EAS_VERSION, truncated2.substring(1));
                            continue block44;
                        }
                        case 'I': {
                            put = table.put(DLS_S_SCANNER_INTERFACE, truncated2.substring(1));
                            continue block44;
                        }
                        case 'r': {
                            put = table.put(DLS_HH_RADIO_VERSION, truncated2.substring(1));
                            continue block44;
                        }
                        case 'L': {
                            put = table.put(DLS_HH_RADIO_APP_VERSION, truncated2.substring(1));
                            continue block44;
                        }
                        case 'b': {
                            put = table.put(DLS_HH_RADIO_BOOTLOADER_VERSION, truncated2.substring(1));
                            continue block44;
                        }
                        case 'x': {
                            put = table.put(DLS_HH_MODEL_NAME, truncated2.substring(1));
                        }
                    }
                }
            }
            buf = this.sendSpecialMsg(spHealthCmd);
            logData = "";
            for (i = 0; i < buf.length; ++i) {
                logData = logData + " 0x" + Integer.toHexString(buf[i] & 0xFF);
            }
            this.log.log(this, "# bytes received[" + buf.length + "]" + logData);
            put = table.put("RawHealth", "# bytes received[" + buf.length + "]" + logData);
            if (buf != null && buf.length != 0) {
                strInfoString = new String(buf);
                strInfo = strInfoString.split("\u0004");
                block46: for (i = 0; i < strInfo.length; ++i) {
                    str = strInfo[i];
                    truncated = str.replaceAll("\\p{Cntrl}", "");
                    truncated2 = truncated.replaceAll("Sp<", "");
                    if (truncated2.equals("")) continue;
                    switch (truncated2.charAt(0)) {
                        case 'm': {
                            put = table.put(DLS_S_MOTOR_HEALTH, truncated2.substring(1));
                            continue block46;
                        }
                        case 'h': {
                            put = table.put(DLS_S_V_LASER_HEALTH, truncated2.substring(1));
                            continue block46;
                        }
                        case 'v': {
                            put = table.put(DLS_S_H_LASER_HEALTH, truncated2.substring(1));
                            continue block46;
                        }
                        case 's': {
                            put = table.put(DLS_S_SCALE_HEALTH, truncated2.substring(1));
                            continue block46;
                        }
                        case 'd': {
                            put = table.put(DLS_S_REMOTE_DISPLAY_HEALTH, truncated2.substring(1));
                            continue block46;
                        }
                        case 'e': {
                            put = table.put(DLS_S_EAS_HEALTH, truncated2.substring(1));
                            continue block46;
                        }
                        case 'c': {
                            put = table.put(DLS_S_CAMERA_HEALTH, truncated2.substring(1));
                            continue block46;
                        }
                        case 'r': {
                            put = table.put(DLS_HH_RADIO_HEALTH, truncated2.substring(1));
                        }
                    }
                }
            }
            buf = this.sendSpecialMsg(spStatisticsCmd);
            logData = "";
            for (i = 0; i < buf.length; ++i) {
                logData = logData + " 0x" + Integer.toHexString(buf[i] & 0xFF);
            }
            this.log.log(this, "# bytes received[" + buf.length + "]" + logData);
            put = table.put("RawStats", "# bytes received[" + buf.length + "]" + logData);
            if (buf != null && buf.length != 0) {
                strInfoString = new String(buf);
                strInfo = strInfoString.split("\u0004");
                block48: for (i = 0; i < strInfo.length; ++i) {
                    str = strInfo[i];
                    truncated = str.replaceAll("\\p{Cntrl}", "");
                    truncated2 = truncated.replaceAll("Sp<", "");
                    if (truncated2.equals("")) continue;
                    switch (truncated2.charAt(0)) {
                        case 'P': {
                            put = table.put(DLS_S_HOURS_POWERED_COUNT, truncated2.substring(1));
                            continue block48;
                        }
                        case 'm': {
                            put = table.put(DLS_S_MOTOR_TIME, truncated2.substring(1));
                            continue block48;
                        }
                        case 'l': {
                            put = table.put(DLS_S_LASER_TIME, truncated2.substring(1));
                            continue block48;
                        }
                        case 'L': {
                            put = table.put(DLS_S_GOOD_SCAN_COUNT, truncated2.substring(1));
                            continue block48;
                        }
                        case 'z': {
                            put = table.put(DLS_S_SCALE_ZEROS, truncated2.substring(1));
                            continue block48;
                        }
                        case 'c': {
                            put = table.put(DLS_S_SCALE_CALS, truncated2.substring(1));
                            continue block48;
                        }
                        case 'C': {
                            put = table.put(DLS_S_SCALE_CAL_TIME, truncated2.substring(1));
                            continue block48;
                        }
                        case 'E': {
                            put = table.put(DLS_S_EAS_DEACTIVATED, truncated2.substring(1));
                            continue block48;
                        }
                        case 'e': {
                            put = table.put(DLS_S_EAS_MANUAL, truncated2.substring(1));
                            continue block48;
                        }
                        case 'B': {
                            put = table.put(DLS_HH_BATTERY_CHG_CYCLES, truncated2.substring(1));
                            continue block48;
                        }
                        case 'T': {
                            put = table.put(DLS_HH_TRIGGER_PULLS, truncated2.substring(1));
                            continue block48;
                        }
                        case 'K': {
                            put = table.put(DLS_HH_KEY_PRESSES, truncated2.substring(1));
                        }
                    }
                }
            }
        }
        put = table.put(DLS_S_DEVICE_CATEGORY, "Scanner");
        put = table.put(DLS_S_INTERFACE, "RS232-SC");
        this.hTable = table;
        this.log.out(this, "getStatistics");
        return table;
    }

    public Hashtable returnStatistics() throws DLSException {
        return this.hTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataReceived(byte[] inBuf, int inLen) {
        Object inBufData = null;
        Object bBuf = null;
        this.log.in(this, "onDataReceived");
        this.parseMessages(inBuf, this.deviceInfo.getRxTrailer(), this.deviceInfo.getUseBCC());
        String decodeType = this.deviceInfo.getDecodingType();
        Iterator it = this.msgList.iterator();
        while (it.hasNext()) {
            byte[] tmpBuf = (byte[])it.next();
            if (tmpBuf.length <= CMD_POS) continue;
            if (tmpBuf[DST_POS] == 51 || tmpBuf[DST_POS] == 50 || tmpBuf[1] == 112) {
                Object object = this.objSpecial;
                synchronized (object) {
                    this.specialBuf = tmpBuf;
                    this.objSpecial.notifyAll();
                    continue;
                }
            }
            if (tmpBuf[DST_POS] != 48) continue;
            switch (tmpBuf[CMD_POS]) {
                case 48: {
                    break;
                }
                case 51: {
                    Object object = this.objSpecial;
                    synchronized (object) {
                        this.specialBuf = tmpBuf;
                        this.objSpecial.notifyAll();
                        break;
                    }
                }
                case 56: {
                    int type = this.extractBarcodeType(tmpBuf[CMD_POS + 1], tmpBuf[CMD_POS + 2]);
                    byte[] barcode = this.extractBarcodeLabel(tmpBuf, CMD_POS + 1);
                    switch (type) {
                        case 101: {
                            if (barcode.length <= 12) break;
                            type = 111;
                            break;
                        }
                        case 102: {
                            if (barcode.length <= 8) break;
                            type = 112;
                            break;
                        }
                        case 103: {
                            if (barcode.length <= 8) break;
                            type = 118;
                            break;
                        }
                        case 104: {
                            if (barcode.length <= 13) break;
                            type = 119;
                        }
                    }
                    DLSProperties options = DLSProperties.getInstance();
                    this.bSendCookedData = options.get("com.dls.jpos.service.ScannerService.sendCookedData", false);
                    if (this.bSendCookedData) {
                        tmpBuf = barcode;
                    }
                    this.fireLabelReceivedEvent(tmpBuf, barcode, type);
                }
            }
        }
        this.msgList.clear();
    }
}

