/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;

public class DLSRegistryAccess {
    private static final String REGQUERY_UTIL = "reg query ";
    private static final String REGSTR_TOKEN = "REG_SZ";
    private static final String REGDWORD_TOKEN = "REG_DWORD";

    public static final String readRegistry(String location, String prefix) {
        String returnString = null;
        try {
            Process process = Runtime.getRuntime().exec("reg query \"" + location + "\" /s ");
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String output = reader.getResult();
            String[] parsed = output.split("\\s");
            boolean bStartFlag = false;
            for (int i = 0; i < parsed.length; ++i) {
                if (parsed[i].contains(prefix)) {
                    bStartFlag = true;
                }
                if (!bStartFlag || !parsed[i].contains("COM")) continue;
                returnString = parsed[i];
                break;
            }
        }
        catch (Exception e) {
            return null;
        }
        return returnString;
    }

    public static final String readRegistry(String location, String key, String value) {
        String returnString = null;
        try {
            Process process;
            String wholeProcessString = REGQUERY_UTIL + location + "/v " + key;
            wholeProcessString = "reg query \"" + location + "\" /s ";
            if (value.contains("/v")) {
                process = Runtime.getRuntime().exec(wholeProcessString);
            } else {
                wholeProcessString = "reg query \"" + location + "\" /s ";
                process = Runtime.getRuntime().exec(wholeProcessString);
            }
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String output = reader.getResult();
            String[] parsed = output.split("\\t");
            for (int i = 0; i < parsed.length; ++i) {
                if (!parsed[i].contains(key)) continue;
                returnString = parsed[i + 2];
                break;
            }
        }
        catch (Exception e) {
            return null;
        }
        return returnString;
    }

    public static String[] readRegistryEntries(String location, String prefix) {
        String[] returnString = new String[10];
        try {
            Process process = Runtime.getRuntime().exec("reg query \"" + location + "\" /s ");
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String output = reader.getResult();
            String[] parsed = output.split("\\s");
            boolean bStartFlag = false;
            int j = 0;
            for (int i = 0; i < parsed.length; ++i) {
                if (parsed[i].contains(prefix)) {
                    bStartFlag = true;
                }
                if (!bStartFlag || !parsed[i].contains("COM")) continue;
                returnString[j++] = parsed[i];
            }
        }
        catch (Exception e) {
            return null;
        }
        return returnString;
    }

    static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw = new StringWriter();

        public StreamReader(InputStream is) {
            this.is = is;
        }

        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getResult() {
            return this.sw.toString();
        }
    }
}

