
// ʹ Windows XP and Vista ½
// ʹ UNICODE 

#ifdef _UNICODE
#if defined _M_IX86
#pragma comment(linker,"/manifestdependency:\"type='win32' name='Microsoft.Windows.Common-Controls' version='6.0.0.0' processorArchitecture='x86' publicKeyToken='6595b64144ccf1df' language='*'\"")
#elif defined _M_IA64
#pragma comment(linker,"/manifestdependency:\"type='win32' name='Microsoft.Windows.Common-Controls' version='6.0.0.0' processorArchitecture='ia64' publicKeyToken='6595b64144ccf1df' language='*'\"")
#elif defined _M_X64
#pragma comment(linker,"/manifestdependency:\"type='win32' name='Microsoft.Windows.Common-Controls' version='6.0.0.0' processorArchitecture='amd64' publicKeyToken='6595b64144ccf1df' language='*'\"")
#else
#pragma comment(linker,"/manifestdependency:\"type='win32' name='Microsoft.Windows.Common-Controls' version='6.0.0.0' processorArchitecture='*' publicKeyToken='6595b64144ccf1df' language='*'\"")
#endif
#endif

// C Ժ
#define _CRT_SECURE_NO_WARNINGS
#include <stdio.h>

#include <string.h>
#include <stdlib.h>
#include <windows.h> // for Sleep()

// JHScale  C ͷļ

#include "JHScale.h"
//#pragma comment(lib, "JHScale.lib")

// 豸ִϴۼ¼

static void do_upload_report(void* hDevice)
{
	int nReport, i;
	REPORT report;

	// 豸ۼ¼
	// JH_ClearReport(hDevice, 100);

	if (JH_GetReport(hDevice, 1))
	{
		nReport = JH_GetFirstReport(hDevice);

		for(i = 0; i < nReport; i++)
		{
			if (JH_GetNextReport(hDevice, &report))
				printf("%d\t%d-%d-%d\t%d:%d:%d\t%d\t%d\t%d\n", 
				report.FID,
				report.Year, report.Month, report.Day, report.Hour, report.Minute, report.Second,
				report.SubID, report.PLU, report.Reject);
		}
	}
}

// 豸ִг

static void do_common_task(void* hDevice)
{
	INFO info;
	TIME time;
	// 豸ַַÿַΪ 64 ַNULַ
	// ַĸʽΪ "192.168.1.111:33581"
	char ip[64+1] = "";

	JH_GetPeerName(hDevice, ip, 64);

	JH_InitInfo(&info);
	JH_InitTime(&time);
	strcpy(info.shopName, "̵");
	strcpy(info.machineName, "");
	info.machineNumber++;
	if (JH_SetInfo( hDevice, &info)
		&& JH_GetInfo( hDevice, &info)
		&& JH_SetTime( hDevice, &time)
		&& JH_GetTime( hDevice, &time))
	{
		printf("%s : %s - %s - %d %d/%d/%d %d:%d:%d\n",
			ip, info.shopName, info.machineName, info.machineNumber,
			time.Year, time.Month, time.Day, time.Hour, time.Minute, time.Second);
	}

	// ¼ĺʾ
	JH_SetPassword(hDevice, 1, 1234567);
	JH_SetTMSpec(hDevice, 2, 200);
	JH_SetTMText(hDevice, 3, "hello");
}

// 豸ִϴӡʽ

static void do_upload_print_format(void* hDevice)
{
	PRINT_FORMAT printFormat;
	PRINT_FORMAT_ITEM printFormatItem;
	int nPrintFormat = 0; // ϴӡʽʱʹõļ
	int nPrintFormatItem = 0; // ϴӡʽʱʹõļ
	int j, k;

	if (JH_GetPrintFormat(hDevice, 0))
	{
		nPrintFormat = JH_GetFirstPrintFormat(hDevice);

		for(j = 0; j < nPrintFormat; j++)
		{
			if (JH_GetNextPrintFormat(hDevice, &printFormat))
			{
				printf("%d-%s: ", printFormat.ID, printFormat.Name);

				// ȡӡʽϢ
				nPrintFormatItem = JH_GetFirstPrintFormatItem(hDevice, printFormat.ID);

				for(k = 0; k < nPrintFormatItem; k++)
				{
					if (JH_GetNextPrintFormatItem(hDevice, printFormat.ID, &printFormatItem))
					{
						printf("%d ", printFormatItem.ID);
					}
				}

				printf("\n");
			}
		}
	}
}

// 豸ִϴ PLU 

static void do_upload_plu(void* hDevice)
{
	PLU plu;
	int nPLU = 0; // ϴ PLU ʱʹõļ
	int j;

	if (JH_GetPLU(hDevice, 0))
	{
		nPLU = JH_GetFirstPLU(hDevice);

		for(j = 0; j < nPLU; j++)
		{
			if (JH_GetNextPLU(hDevice, &plu))
				printf("%s\t%d\t%d\t%d\t%d\t%d\t%d\t\n", plu.Text[0],
				plu.TaxSort, plu.TaxData,
				plu.SspValue[0], plu.SspValue[1], plu.SspValue[2], plu.SspValue[3]);
		}
	}
}

//  PLU б

static void do_make_plu()
{
	PLU plu;
	int i;

	// ʼ׼ PLU б
	JH_SetFirstPLU();	

	//  10 µ PLU 
	for(i = 1; i <= 100; i++)
	{
		// ȳʼ PLU ṹΪĬ״̬
		JH_InitPLU(&plu);

		// ֹñšơעͺźͼ۸
		plu.ID = i;
		sprintf(plu.Text[0], "PLU %d", i);
		plu.Remark = 10 + i;
		plu.Cost = 12.34 + (double)i;
		plu.TaxSort = 10;
		plu.TaxData = 11;

		plu.SspValue[0] = 12;
		plu.SspValue[1] = 13;
		plu.SspValue[2] = 14;
		plu.SspValue[3] = 15;

		// Ӹ PLU
		JH_SetNextPLU(&plu);
	}
}

// شӡʽб

static void do_make_print_format()
{
	PRINT_FORMAT printFormat;
	PRINT_FORMAT_ITEM printFormatItem;
	
	int i, j;

	// ʼ׼ӡʽб
	JH_SetFirstPrintFormat();	

	//  16 µĴӡʽ
	for(i = 11; i <= 16; i++)
	{
		// ȳʼӡʽṹΪĬ״̬
		JH_InitPrintFormat(&printFormat);

		// ֹñšơעͺźͼ۸
		printFormat.ID = i;
		sprintf(printFormat.Name, "Print Format %d", i);

		// Ӹӡʽ
		JH_SetNextPrintFormat(&printFormat);

		// Ӹӡʽ

		JH_SetFirstPrintFormatItem(i);

		for(j = 0; j < i; j++)
		{
			JH_InitPrintFormatItem(&printFormatItem);
			printFormatItem.ID = j;
			printFormatItem.Left += j * 10;
			printFormatItem.Top += j * 10;
			JH_SetNextPrintFormatItem(i, &printFormatItem);
		}
	}
}

// ʾغ
// ʹͼν
void test_font_window(const char* filename)
{
	int count, i;

	// ʶ豸ľ
	void **hDevices = NULL;

	// 豸ַַÿַΪ 64 ַNULַ
	// ַĸʽΪ "192.168.1.111:33581"
	char ip[64+1] = "";

	// ļ, ·߾·
	printf("ڼļ %s ...\n", filename);
	if  (!JH_LoadFont(filename))
	{
		printf("ļʧ.\n");
		return;
	}

	JH_ResetDevice();

	// ͨUDP㲥ȡĿǰܹҵ豸
	printf("ڹ㲥豸, ȴ...\n");
	count = JH_FindDeviceUDP(33583, 33584, 5000);
	if (count > 0)
	{
		// ̬
		hDevices = (void**)calloc(count, sizeof(void*));

		if (hDevices != NULL)
		{
			for (i = 0; i < count; i++)
			{
				// ȡһ豸ĵַ
				if (JH_FindNextDeviceUDP(ip, 64) != 0)
				{
					// 豸
					hDevices[i] = JH_Connect(ip, 5000, 5000, 5000, 1024, 1024);
					if (JH_IsConnected(hDevices[i]))
					{
						// 豸û豸б
						printf("豸 - %s ...\n", ip);
						JH_AddDevice(hDevices[i]);	
					}				
				}
				else
				{
					// ûпõ豸ˣ˳ѭ
					break;
				}

			}

			// ʾͼν
			JH_SetFont_Window(0, 1);

			for (i = 0; i < count; i++)
			{
				// Ҫǹر豸ԱͷԴ
				JH_Close(hDevices[i]);
				hDevices[i] = NULL;
			}

			// ͷŶ̬
			free(hDevices);
		}
	}
}

// ʾغ
// ʹ UDP 㲥豸

void test_font(const char* filename)
{
	int count, i;

	// 豸ַַÿַΪ 64 ַNULַ
	// ַĸʽΪ "192.168.1.111:33581"
	char ip[64+1] = "";

	// ʶ豸ľ
	void *hDevice = NULL;

	// ļ, ·߾·
	printf("ڼļ %s ...\n", filename);
	if  (!JH_LoadFont(filename))
	{
		printf("ļʧ.\n");
		return;
	}

	// ͨUDP㲥ȡĿǰܹҵ豸
	printf("ڹ㲥豸, ȴ...\n");
	count = JH_FindDeviceUDP(33583, 33584, 5000);
	if (count > 0)
	{
		for (i = 0; i < count; i++)
		{
			// ȡһ豸ĵַ
			if (JH_FindNextDeviceUDP(ip, 64) != 0)
			{
				// 豸
				hDevice = JH_Connect(ip, 5000, 5000, 5000, 1024, 1024);
				if (JH_IsConnected(hDevice))
				{
					// 豸
					// printf(" - %s ...\n", ip);
					// JH_ClearFont(hDevice, 0);

					// Ըոռص壬
					printf(" - %s ...\n", ip);
					JH_SetFont(hDevice);		

					// Ҫǹر豸ԱͷԴ
					JH_Close(hDevice);
					hDevice = NULL;
				}				
			}
			else
			{
				// ûпõ豸ˣ˳ѭ
				break;
			}
		}
	}
}

// ʾӡʽ
// ʹ UDP 㲥豸

void test_print_format(void)
{
	int count, i;

	// 豸ַַÿַΪ 64 ַNULַ
	// ַĸʽΪ "192.168.1.111:33581"
	char ip[64+1] = "";

	// ʶ豸ľ
	void *hDevice = NULL;

	do_make_print_format();

	// ͨUDP㲥ȡĿǰܹҵ豸
	printf("ڹ㲥豸, ȴ...\n");
	count = JH_FindDeviceUDP(33583, 33584, 5000);
	if (count > 0)
	{
		for (i = 0; i < count; i++)
		{
			// ȡһ豸ĵַ
			if (JH_FindNextDeviceUDP(ip, 64) != 0)
			{
				// 豸
				hDevice = JH_Connect(ip, 5000, 5000, 5000, 1024, 1024);
				if (JH_IsConnected(hDevice))
				{
					// 豸дӡʽ
					// printf("ӡʽ - %s ...\n", ip);
					// JH_ClearPrintFormat(hDevice, 0);

					// ԸոսĴӡʽбشӡʽ
					printf("شӡʽ - %s ...\n", ip);
					JH_SetPrintFormat(hDevice);		

					printf("ϴӡʽ - %s ...\n", ip);
					do_upload_print_format(hDevice);

					// Ҫǹر豸ԱͷԴ
					JH_Close(hDevice);
					hDevice = NULL;
				}				
			}
			else
			{
				// ûпõ豸ˣ˳ѭ
				break;
			}
		}
	}
}

// ʾ׷뺯
// ʹ UDP 㲥豸

void test_tc1(void)
{
	int count, i, j;

	// 豸ַַÿַΪ 64 ַNULַ
	// ַĸʽΪ "192.168.1.111:33581"
	char ip[64+1] = "";

	// ʶ豸ľ
	void *hDevice = NULL;

	TC1 tc1;
	int nTC1 = 0; // ϴ׷ʱʹõļ

	// ʼ׼׷б
	JH_SetFirstTC1();	

	//  10 µ׷
	for(i = 1; i <= 10; i++)
	{
		// ȳʼ׷ṹΪĬ״̬
		JH_InitTC1(&tc1);

		// ֹñšơעͺźͼ۸
		tc1.ID = i;
		sprintf(tc1.Code, "Code %d", i);
		tc1.Weight = 12.34 + (double)i;

		// Ӹ׷
		JH_SetNextTC1(&tc1);
	}

	// ͨUDP㲥ȡĿǰܹҵ豸
	printf("ڹ㲥豸, ȴ...\n");
	count = JH_FindDeviceUDP(33583, 33584, 5000);
	if (count > 0)
	{
		for (i = 0; i < count; i++)
		{
			// ȡһ豸ĵַ
			if (JH_FindNextDeviceUDP(ip, 64) != 0)
			{
				// 豸
				hDevice = JH_Connect(ip, 5000, 5000, 5000, 1024, 1024);
				if (JH_IsConnected(hDevice))
				{
					// 豸׷
					printf("׷ - %s ...\n", ip);
					JH_ClearTC1(hDevice, 0);

					// Ըոս׷б׷
					printf("׷ - %s ...\n", ip);
					JH_SetTC1(hDevice);		

					printf("ϴ׷ - %s ...\n", ip);
					if (JH_GetTC1(hDevice, 0))
					{
						nTC1 = JH_GetFirstTC1(hDevice);

						for(j = 0; j < nTC1; j++)
						{
							if (JH_GetNextTC1(hDevice, &tc1))
								printf("%s\t%d-%d-%d\t%d:%d:%d\t%lf\n", 
								tc1.Code,
								tc1.Year, tc1.Month, tc1.Day, 
								tc1.Hour, tc1.Minute, tc1.Second,
								tc1.Weight);
						}
					}

					// Ҫǹر豸ԱͷԴ
					JH_Close(hDevice);
					hDevice = NULL;
				}				
			}
			else
			{
				// ûпõ豸ˣ˳ѭ
				break;
			}
		}
	}
}

// ʾTR1
// ʹ UDP 㲥豸

void test_tr1(void)
{
	int count, i, j;

	// 豸ַַÿַΪ 64 ַNULַ
	// ַĸʽΪ "192.168.1.111:33581"
	char ip[64+1] = "";

	// ʶ豸ľ
	void *hDevice = NULL;

	TR1 tr1;
	int nTR1 = 0; // ϴ׷ʱʹõļ

	// ʼ׼׷б
	JH_SetFirstTR1();	

	//  10 µ׷
	for(i = 1; i <= 10; i++)
	{
		// ȳʼ׷ṹΪĬ״̬
		JH_InitTR1(&tr1);

		// ֹñšơעͺźͼ۸
		tr1.ID = i;
		sprintf(tr1.Name, "Name %d", i);


		// Ӹ׷
		JH_SetNextTR1(&tr1);
	}

	// ͨUDP㲥ȡĿǰܹҵ豸
	printf("ڹ㲥豸, ȴ...\n");
	count = JH_FindDeviceUDP(33583, 33584, 5000);
	if (count > 0)
	{
		for (i = 0; i < count; i++)
		{
			// ȡһ豸ĵַ
			if (JH_FindNextDeviceUDP(ip, 64) != 0)
			{
				// 豸
				hDevice = JH_Connect(ip, 5000, 5000, 5000, 1024, 1024);
				if (JH_IsConnected(hDevice))
				{
					// 豸׷
					printf("׷ - %s ...\n", ip);
					JH_ClearTR1(hDevice, 0);

					// Ըոս׷б׷
					printf("׷ - %s ...\n", ip);
					JH_SetTR1(hDevice);		

					printf("ϴ׷ - %s ...\n", ip);
					if (JH_GetTR1(hDevice, 0))
					{
						nTR1 = JH_GetFirstTR1(hDevice);

						for(j = 0; j < nTR1; j++)
						{
							if (JH_GetNextTR1(hDevice, &tr1))
								printf("%d\t%s\t\n", 
								tr1.ID, tr1.Name);
						}
					}

					// Ҫǹر豸ԱͷԴ
					JH_Close(hDevice);
					hDevice = NULL;
				}				
			}
			else
			{
				// ûпõ豸ˣ˳ѭ
				break;
			}
		}
	}
}

void test_Dept(void)
{
	int count, i, j;

	// 豸ַַÿַΪ 64 ַNULַ
	// ַĸʽΪ "192.168.1.111:33581"
	char ip[64+1] = "";

	// ʶ豸ľ
	void *hDevice = NULL;

	DEPT dept;
	int nDEPT = 0; // ϴ׷ʱʹõļ

	// ʼ׼׷б
	JH_SetFirstDept();	

	//  10 µ׷
	for(i = 1; i <= 10; i++)
	{
		// ȳʼ׷ṹΪĬ״̬
		JH_InitDept(&dept);

		// ֹñšơעͺźͼ۸
		dept.ID = i;
		sprintf(dept.Name, "Name %d", i);


		// Ӹ׷
		JH_SetNextDept(&dept);
	}

	// ͨUDP㲥ȡĿǰܹҵ豸
	printf("ڹ㲥豸, ȴ...\n");
	count = JH_FindDeviceUDP(33583, 33584, 5000);
	if (count > 0)
	{
		for (i = 0; i < count; i++)
		{
			// ȡһ豸ĵַ
			if (JH_FindNextDeviceUDP(ip, 64) != 0)
			{
				// 豸
				hDevice = JH_Connect(ip, 5000, 5000, 5000, 1024, 1024);
				if (JH_IsConnected(hDevice))
				{
					// 豸׷
					printf("׷ - %s ...\n", ip);
					JH_ClearDept(hDevice, 0);

					// Ըոս׷б׷
					printf("׷ - %s ...\n", ip);
					JH_SetDept(hDevice);		

					printf("ϴ׷ - %s ...\n", ip);
					if (JH_GetDept(hDevice, 0))
					{
						nDEPT = JH_GetFirstDept(hDevice);

						for(j = 0; j < nDEPT; j++)
						{
							if (JH_GetNextDept(hDevice, &dept))
								printf("%d\t%s\t\n", 
								dept.ID, dept.Name);
						}
					}

					// Ҫǹر豸ԱͷԴ
					JH_Close(hDevice);
					hDevice = NULL;
				}				
			}
			else
			{
				// ûпõ豸ˣ˳ѭ
				break;
			}
		}
	}
}



// ʾ PLU 
// ʹ UDP 㲥豸

void test_plu(void)
{
	int count, i;

	// 豸ַַÿַΪ 64 ַNULַ
	// ַĸʽΪ "192.168.1.235:33581"
	char ip[64+1] = "";

	// ʶ豸ľ
	void *hDevice = NULL;

	do_make_plu();

	// ͨUDP㲥ȡĿǰܹҵ豸
	printf("ڹ㲥豸, ȴ...\n");
//	count = JH_FindDeviceUDP(33583, 33584, 5000);
    count = 1;
	if (count > 0)
	{
		for (i = 0; i < count; i++)
		{
			// ȡһ豸ĵַ
//			if (JH_FindNextDeviceUDP(ip, 64) != 0)
			if (1 == 1)
			{
				strcpy(ip, "192.168.1.235:33581");
				strcpy(ip, "192.14.13.175:33581");
				strcpy(ip, "192.168.11.5:33581");
				strcpy(ip, "127.0.0.1:33581");

				// 豸
				hDevice = JH_Connect(ip, 5000, 5000, 5000, 1024, 1024);
				if (JH_IsConnected(hDevice))
				{
//					JH_SetConnectType(hDevice, 1);

					// 豸 PLU
					printf(" PLU - %s ...\n", ip);
					JH_ClearPLU(hDevice, 0);

					// Ըոս PLU б豸б PLU
					printf(" PLU - %s ...\n", ip);
					JH_SetPLU(hDevice);		

					printf("ϴ PLU - %s ...\n", ip);
					do_upload_plu(hDevice);

					// Ҫǹر豸ԱͷԴ
					JH_Close(hDevice);
					hDevice = NULL;
				}				
			}
			else
			{
				// ûпõ豸ˣ˳ѭ
				break;
			}
		}
	}
}

// ʾû溯
// ʹ UDP 㲥豸ϴ PLU

void test_plu_window(void)
{
	int count, i, j;

	// 豸ַַÿַΪ 64 ַNULַ
	// ַĸʽΪ "192.168.1.111:33581"
	char ip[64+1] = "";


	PLU plu;
	int nPLU;

	// ʶ豸ľ
	void **hDevices = NULL;

	do_make_plu();

	JH_ResetDevice();

	// ͨUDP㲥ȡĿǰܹҵ豸
	printf("ڹ㲥豸, ȴ...\n");
	count = JH_FindDeviceUDP(33583, 33584, 5000);
	if (count > 0)
	{
		// ̬
		hDevices = (void**)calloc(count, sizeof(void*));

		if (hDevices != NULL)
		{
			for (i = 0; i < count; i++)
			{
				// ȡһ豸ĵַ
				if (JH_FindNextDeviceUDP(ip, 64) != 0)
				{
					// 豸
					hDevices[i] = JH_Connect(ip, 5000, 5000, 5000, 1024, 1024);
					if (JH_IsConnected(hDevices[i]))
					{
						// 豸 PLU
						printf(" PLU - %s ...\n", ip);
						JH_ClearPLU(hDevices[i], 0);

						// 豸û豸б
						printf("豸 - %s ...\n", ip);
						JH_AddDevice(hDevices[i]);	
					}				
				}
				else
				{
					// ûпõ豸ˣ˳ѭ
					break;
				}

			}

			if (JH_SetPLU_Window(0, 0))
			{
				if (JH_GetPLU_Window(0, 0, 0))
				{
					// òʾ豸PLU
					for (i = 0; i < count; i++)
					{
						nPLU = JH_GetFirstPLU(hDevices[i]);
						for(j = 0; j < nPLU; j++)
						{
							if (JH_GetNextPLU(hDevices[i], &plu)
								&& JH_GetPeerName(hDevices[i], ip, 64))
								printf("%s\t%s\n", ip, plu.Text[0]);
						}
					}
				}
			}


			for (i = 0; i < count; i++)
			{
				// Ҫǹر豸ԱͷԴ
				JH_Close(hDevices[i]);
				hDevices[i] = NULL;
			}

			// ͷŶ̬
			free(hDevices);
		}
	}
}

// ʾۼ¼
// ʹ UDP 㲥豸

void test_report(void)
{
	int count, i;

	// 豸ַַÿַΪ 64 ַNULַ
	// ַĸʽΪ "192.168.1.111:33581"
	char ip[64+1] = "";

	// ʶ豸ľ
	void *hDevice = NULL;

	// ͨUDP㲥ȡĿǰܹҵ豸
	printf("ڹ㲥豸, ȴ...\n");
	count = JH_FindDeviceUDP(33583, 33584, 5000);
	if (count > 0)
	{
		for (i = 0; i < count; i++)
		{
			// ȡһ豸ĵַ
			if (JH_FindNextDeviceUDP(ip, 64) != 0)
			{
				// 豸
				hDevice = JH_Connect(ip, 5000, 5000, 5000, 1024, 1024);
				if (JH_IsConnected(hDevice))
				{
					// ϴۼ¼
					printf("ϴ־ %s ...\n", ip);
					do_upload_report(hDevice);

					// Ҫǹر豸ԱͷԴ
					JH_Close(hDevice);
					hDevice = NULL;
				}				
			}
			else
			{
				// ûпõ豸ˣ˳ѭ
				break;
			}
		}
	}
}

// ʾ TCP 
// ʾú

void test_tcp(void)
{	
	int i;
	
	// ʶ豸ľ
	void *hDevice = NULL;

	// ͨ TCP 㲥ȡĿǰܹҵ豸
	printf("򿪷豸\n");
	if (!JH_FindDeviceTCP(33582)) return;

	for(i = 0; i < 300; i++)
	{
		// ȡһ豸ĵַ
		hDevice = JH_FindNextDeviceTCP(5000, 5000, 1024, 1024);
		if ( JH_IsConnected(hDevice))
		{
			// ִг
			do_common_task(hDevice);

			// Ҫǹر豸ԱͷԴ
			JH_Close(hDevice);
		}
		else
		{
			// ûпõ豸ˣȴ
			Sleep(1000);
			printf("%d û豸\n", i + 1);
		}
	}

	JH_EndFindDeviceTCP();
}

// ʾ UDP 
// ʾú

void test_udp(void)
{
	int count, i;

	// 豸ַַÿַΪ 64 ַNULַ
	// ַĸʽΪ "192.168.1.111:33581"
	char ip[64+1] = "";

	// ʶ豸ľ
	void *hDevice = NULL;

	// ͨUDP㲥ȡĿǰܹҵ豸
	printf("ڹ㲥豸, ȴ...\n");
	count = JH_FindDeviceUDP(33583, 33584, 5000);
	if (count > 0)
	{
		for (i = 0; i < count; i++)
		{
			// ȡһ豸ĵַ
			if (JH_FindNextDeviceUDP(ip, 64) != 0)
			{
				// 豸
				hDevice = JH_Connect(ip, 5000, 5000, 5000, 1024, 1024);
				if (JH_IsConnected(hDevice))
				{
					// ִг
					do_common_task(hDevice);

					// Ҫǹر豸ԱͷԴ
					JH_Close(hDevice);
				}
			}
			else
			{
				// ûпõ豸ˣ˳ѭ
				break;
			}
		}
	}
}

// ʾ TMS ļм PLU ʹӡʽ

void test_plu_printform_file(const char* filename)
{
	// ʶ豸ľ, 
	void *hDevice = NULL;

	do_make_plu();

	do_make_print_format();
	
	//  PLU ʹӡʽļ
	hDevice = JH_OpenFile(0, filename);
	if (JH_IsConnected(hDevice))
	{
		// Ըոս PLU б豸б PLU
		printf(" PLU - %s ...\n", filename);
		JH_SetPLU(hDevice);		

		// ԸոսĴӡʽбشӡʽ
		printf("شӡʽ - %s ...\n", filename);
		JH_SetPrintFormat(hDevice);		

		// Ҫǹر豸ԱͷԴ
		JH_Close(hDevice);
	}	


	// ļ  PLU ʹӡʽ
	hDevice = JH_OpenFile(filename, 0);
	if (JH_IsConnected(hDevice))
	{
		printf("ϴ PLU - %s ...\n", filename);
		do_upload_plu(hDevice);


		printf("ϴӡʽ - %s ...\n", filename);
		do_upload_print_format(hDevice);

		// Ҫǹر豸ԱͷԴ
		JH_Close(hDevice);
	}
}

// ʾӴмۼ¼

void test_report_serial(int port, int baudRate)
{
	// ʶ豸ľ, ļжȡۼ¼
	void *hDevice = NULL;

	// Ӵڵۼ¼
	hDevice = JH_OpenSerialPort(port, baudRate, 0, 0, 8, 5000, 5000, 1024, 1024);
	if (JH_IsConnected(hDevice))
	{				
		// ϴ־
		printf("ϴ־ COM%d ...\n", port);

		do_upload_report(hDevice);

		// Ҫǹر豸ԱͷԴ
		JH_Close(hDevice);
	}	
}

// ʾ USB м PLU

void test_plu_usb(int vid, int pid)
{
	// ʶ豸ľ, 
	void *hDevice = NULL;

	do_make_plu();

	//  PLU ʹӡʽ USB
	hDevice = JH_OpenUsb(vid, pid, 0x81, 0x01, 5000, 1024);
	if (JH_IsConnected(hDevice))
	{
		// Ըոս PLU б豸б PLU
		printf(" PLU - VID:%04X PID:%04X  ...\n", vid, pid);
		JH_SetPLU(hDevice);		

		//  USB  PLU 
		printf("ϴ PLU - VID:%04X PID:%04X  ...\n", vid, pid);
		do_upload_plu(hDevice);

		// Ҫǹر豸ԱͷԴ
		JH_Close(hDevice);
	}
}


// ʾԶ庯 ģɺ豸λƵĹܣ
// ʹ UDP 㲥豸

void test_custom(const char *filename)
{
	int count, i, j;
		
	// 豸ַַÿַΪ 64 ַNULַ
	// ַĸʽΪ "192.168.1.111:33581"
	char ip[64+1] = "";

	// ʶ豸ľ
	void *hDevice = NULL;
	
	CUSTOM custom;
	int nCustom = 0; // ϴԶʱʹõļ

	// Զļ, ·߾·
	printf("ڼԶļ %s ...\n", filename);
	if  (!JH_LoadCustom(filename))
	{
		printf("ļʧ.\n");
		return;
	}
	
	// ʼ׼Զб
	JH_SetFirstCustom();	

	//  10 µԶ
	for(i = 1; i <= 10; i++)
	{
		// ȳʼԶṹΪĬ״̬
		JH_InitCustom(&custom);

		// ֹñš
		custom.ID = i + 30;
		sprintf(custom.Text[0], "Custom %d", i); // name
		custom.Integer[0] = i % 2; // punit
		custom.Decimal[0] = 12.34 + (double)i; // pack

		// ӸԶ
		JH_SetNextCustom(&custom);
	}

	// ͨUDP㲥ȡĿǰܹҵ豸
	printf("ڹ㲥豸, ȴ...\n");
	count = JH_FindDeviceUDP(33583, 33584, 5000);
	if (count > 0)
	{
		for (i = 0; i < count; i++)
		{
			// ȡһ豸ĵַ
			if (JH_FindNextDeviceUDP(ip, 64) != 0)
			{
				// 豸
				hDevice = JH_Connect(ip, 5000, 5000, 5000, 1024, 1024);
				if (JH_IsConnected(hDevice))
				{
					// 豸Զ
					// printf("Զ - %s ...\n", ip);
					// JH_ClearCustom(hDevice, 0);

					// ԸոսԶбԶ
					printf("Զ - %s ...\n", ip);
					JH_SetCustom(hDevice);		

					printf("ϴԶ - %s ...\n", ip);
					if (JH_GetCustom(hDevice, 0))
					{
						nCustom = JH_GetFirstCustom(hDevice);

						for(j = 0; j < nCustom; j++)
						{
							if (JH_GetNextCustom(hDevice, &custom))
								printf("%d\t%s\t%d\t%lf\n", 
								custom.ID,
								custom.Text[0],
								custom.Integer[0],
								custom.Decimal[0]);
						}
					}

					// Ҫǹر豸ԱͷԴ
					JH_Close(hDevice);
					hDevice = NULL;
				}				
			}
			else
			{
				// ûпõ豸ˣ˳ѭ
				break;
			}
		}
	}
}

void test_JHs()
{
	char ip[64+1];

	strcpy(ip, "192.14.13.175:33581");
	strcpy(ip, "192.168.11.5:33581");
	strcpy(ip, "127.0.0.1:33581");


//	JHs_String_Init();

//	JHs_ToScale_Device_PLU("E:\\YSSCALE\\WORK\\JHScale_20120220_JHs\\JHScale\\DATA\\ʯ_Load.txt", ip);

	JHs_FromScale_Device_PLU(ip, "E:\\YSSCALE\\WORK\\JHScale_20120220_JHs\\JHScale\\DATA\\ʯ_Save.txt");

/*
	JHs_ToScale_Device_List_PLU(
		"E:\\YSSCALE\\WORK\\JHScale_20120220_JHs\\JHScale\\DATA\\plu_data.txt", 
		"E:\\YSSCALE\\WORK\\JHScale_20120220_JHs\\JHScale\\DATA\\ip.txt", 
		0);
*/

}

void test_string_window(void)
{
	int count, i, j;

	// 豸ַַÿַΪ 64 ַNULַ
	// ַĸʽΪ "192.168.1.111:33581"
	char ip[64+1] = "";


	PLU plu;
	int nPLU;

	// ʶ豸ľ
	void **hDevices = NULL;

	do_make_plu();

	JH_ResetDevice();

	// ̬
	hDevices = (void**)calloc(2, sizeof(void*));

	if (hDevices != NULL)
	{
		hDevices[0] = JH_Connect("192.168.1.100", 5000, 5000, 5000, 1024, 1024);
		JH_AddDevice_NoCheck(hDevices[0]);	
		hDevices[1] = JH_Connect("192.168.1.101", 5000, 5000, 5000, 1024, 1024);
		JH_AddDevice_NoCheck(hDevices[1]);	

		count=2;

		if (JH_SetPLU_Window(0, 0))
		{
			if (JH_GetPLU_Window(0, 0, 0))
			{
				// òʾ豸PLU
				for (i = 0; i < count; i++)
				{
					nPLU = JH_GetFirstPLU(hDevices[i]);
					for(j = 0; j < nPLU; j++)
					{
						if (JH_GetNextPLU(hDevices[i], &plu)
							&& JH_GetPeerName(hDevices[i], ip, 64))
							printf("%s\t%s\n", ip, plu.Text[0]);
					}
				}
			}
		}


		for (i = 0; i < count; i++)
		{
			// Ҫǹر豸ԱͷԴ
			JH_Close(hDevices[i]);
			hDevices[i] = NULL;
		}

		// ͷŶ̬
		free(hDevices);
	}
}

#pragma comment( linker, "/subsystem:\"windows\" /entry:\"mainCRTStartup\"" )

int main()
{
	int rv;

	// ʾ
	
	// test_udp();
	// test_tcp();

	// test_plu();
	// test_report();
	// test_tc1();
	// test_tr1();
	// test_Dept();
	// test_print_format();
	// test_font("Font.bin");
	
	// test_plu_printform_file("A_000.TMS");
	// test_report_serial(1, 9600);
	// test_plu_usb(0x04D8, 0x0204);

	// test_plu_window();

	// test_font_window("Font.bin");

	// test_custom("unit_custom.ini");

	//test_JHs();

	//StringFormat_Test("C:\\TM.txt","C:\\out.txt");

	 /*
	rv=JHScale_TxDevice(0,0);
	if(rv==0)
	{
		printf("OK\n");
	}
	else if(rv==1)
	{
		printf("Connect Error\n");
	}
	else if(rv==2)
	{
		printf("File Error\n");
	}
	else
	{
		printf("Unkown Error\n");
	}

	system("pause");
	*/

	JHScale_TxList(0,0);

	return 0;
}