﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;

namespace MyIpTextBox
{
    public partial class IpTextBox : UserControl
    {
        private Regex drg = new Regex("\\d");
        private Color Bordercolor = Color.Black;
        private string iptext = "0.0.0.0";
        private int ip1 = 0;
        private int ip2 = 0;
        private int ip3 = 0;
        private int ip4 = 0;


        public IpTextBox()
        {
            InitializeComponent();
            this.textBox1.Text = "0";
            this.textBox2.Text = "0";
            this.textBox3.Text = "0";
            this.textBox4.Text = "0";
        }

        [Description("设置边框颜色")]　//显示在属性设计视图中的描述
        [DefaultValue(typeof(Color), "Black")]//给予初始值
        public Color BorderColor
        {
            get { return Bordercolor; }
            set
            {
                Bordercolor = value;
            }
        }

        [Description("IP值")]　//显示在属性设计视图中的描述
        public string IpText
        {
            get { return iptext; }
            set
            {
                if (value.Split('.').Length != 4)
                    MessageBox.Show("无效属性值", "警告");
                else
                {
                    string[] ip = value.Split('.');
                    ip1 = Int16.Parse(ip[0]);
                    ip2 = Int16.Parse(ip[1]);
                    ip3 = Int16.Parse(ip[2]);
                    ip4 = Int16.Parse(ip[3]);

                    textBox1.Text = ip[0];
                    textBox2.Text = ip[1];
                    textBox3.Text = ip[2];
                    textBox4.Text = ip[3];

                    iptext = value;
                }
            }
        }

        public int IP1
        {
            get { return ip1; }
            set
            {
                if (value>=0 && value <256) 
                {
                    ip1 = value ;
                    textBox1.Text = ip1.ToString();
                    iptext = ip1.ToString() +"."+ ip2.ToString() +"."+ ip3.ToString() +"."+ ip4.ToString();
                }
            }
        }
        public int IP2
        {
            get { return ip2; }
            set
            {
                if (value >= 0 && value < 256) 
                {
                    ip2 = value;
                    textBox2.Text = ip2.ToString();
                    iptext = ip1.ToString() + "." + ip2.ToString() + "." + ip3.ToString() + "." + ip4.ToString();
                }
            }
        }
        public int IP3
        {
            get { return ip3; }
            set
            {
                if (value >= 0 && value < 256) 
                {
                    ip3 = value;
                    textBox3.Text = ip3.ToString();
                    iptext = ip1.ToString() + "." + ip2.ToString() + "." + ip3.ToString() + "." + ip4.ToString();
                }
            }
        }
        public int IP4
        {
            get { return ip4; }
            set
            {
                if (value >= 0 && value < 256) 
                {
                    ip4 = value;
                    textBox4.Text = ip4.ToString();
                    iptext = ip1.ToString() + "." + ip2.ToString() + "." + ip3.ToString() + "." + ip4.ToString();
                }
            }
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            if (textBox1.Text.Length == 3)
            {
                textBox2.Focus();
                textBox2.Select(0, textBox2.Text.Length);
            }
            if (textBox1.Text != "" && int.Parse(textBox1.Text) > 255)
                textBox1.Text = "255";
            ip1 = Int16.Parse(textBox1.Text == "" ? "0" : textBox1.Text);

            iptext = ip1.ToString() + "." + ip2.ToString() + "." + ip3.ToString() + "." + ip4.ToString();
        }

        private void textBox2_TextChanged(object sender, EventArgs e)
        {
            if (textBox2.Text.Length == 3)
            {
                textBox3.Focus();
                textBox3.Select(0, textBox3.Text.Length);
            }
            if (textBox2.Text != "" && int.Parse(textBox2.Text) > 255)
                textBox2.Text = "255";
            ip2 = Int16.Parse(textBox2.Text == "" ? "0" : textBox2.Text);

            iptext = ip1.ToString() + "." + ip2.ToString() + "." + ip3.ToString() + "." + ip4.ToString();
        }

        private void textBox3_TextChanged(object sender, EventArgs e)
        {
            if (textBox3.Text.Length == 3)
            {
                textBox4.Focus();
                textBox4.Select(0, textBox4.Text.Length);
            }
            if (textBox3.Text != "" && int.Parse(textBox3.Text) > 255)
                textBox3.Text = "255";
            ip3 = Int16.Parse(textBox3.Text == "" ? "0" : textBox3.Text);

            iptext = ip1.ToString() + "." + ip2.ToString() + "." + ip3.ToString() + "." + ip4.ToString();
        }

        private void textBox4_TextChanged(object sender, EventArgs e)
        {
            if (textBox4.Text!=""&&int.Parse(textBox4.Text) > 255)
                textBox4.Text = "255";
            ip4 = Int16.Parse(textBox4.Text==""?"0":textBox4.Text);

            iptext = ip1.ToString() + "." + ip2.ToString() + "." + ip3.ToString() + "." + ip4.ToString();
        }

        private void textBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if(e.KeyChar=='\b')
            {
                if (textBox1.Text.Length == 0)
                {
                    textBox1.Text = "0";
                }
            }
            else if (e.KeyChar == '.')
            {
                e.KeyChar = '\0';
                textBox2.Focus();
                textBox2.SelectionStart = textBox2.Text.Length;
            }
            else if (!drg.IsMatch(e.KeyChar.ToString()))
                e.KeyChar = '\0';
        }

        private void textBox2_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == '\b')
            {
                if (textBox2.Text.Length == 0)
                {
                    textBox2.Text = "0";
                    textBox1.Focus();
                    textBox1.SelectionStart = textBox1.Text.Length;
                }
            }
            else if (e.KeyChar == '.')
            {
                textBox3.Focus();
                e.KeyChar = '\0';
            }
            else if (!drg.IsMatch(e.KeyChar.ToString()))
                e.KeyChar = '\0';
        }

        private void textBox3_KeyPress(object sender, KeyPressEventArgs e)
        {
            if(e.KeyChar=='\b')
            {
                if (textBox3.Text.Length == 0)
                {
                    textBox3.Text = "0";
                    textBox2.Focus();
                    textBox2.SelectionStart = textBox2.Text.Length;
                }
            }
            else if (e.KeyChar == '.')
            {
                textBox4.Focus();
                e.KeyChar = '\0';
            }
            else if (!drg.IsMatch(e.KeyChar.ToString()))
                e.KeyChar = '\0';
        }

        private void textBox4_KeyPress(object sender, KeyPressEventArgs e)
        {
            if(e.KeyChar=='\b')
            {
                if (textBox4.Text.Length == 0)
                {
                    textBox4.Text = "0";
                    textBox3.Focus();
                    textBox3.SelectionStart = textBox3.Text.Length;
                }
            }
            else if (!drg.IsMatch(e.KeyChar.ToString()))
                e.KeyChar = '\0';
            
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            Graphics g = this.CreateGraphics(); 
            Pen p = new Pen(Bordercolor, 1);
            g.DrawRectangle(p, 0, 0, 122, 22);//画边框
            g.DrawArc(p, 30, 12, 1, 1, 45, 270);//画点
            g.DrawArc(p, 61, 12, 1, 1, 45, 270);
            g.DrawArc(p, 92, 12, 1, 1, 45, 270);
            base.OnPaint(e);
        }

        private void textBox1_Leave(object sender, EventArgs e)
        {
            if (textBox1.Text == "") textBox1.Text = "0";
        }

        private void textBox2_Leave(object sender, EventArgs e)
        {
            if (textBox2.Text == "") textBox2.Text = "0";
        }

        private void textBox3_Leave(object sender, EventArgs e)
        {
            if (textBox3.Text == "") textBox3.Text = "0";
        }

        private void textBox4_Leave(object sender, EventArgs e)
        {
            if (textBox4.Text == "") textBox4.Text = "0";
        }



    }
}